/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Date;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.PeriodState;

public class InfoExecutionYear
extends InfoObject {
    private final ExecutionYear executionYearDomainReference;

    public InfoExecutionYear(ExecutionYear executionYear) {
        this.executionYearDomainReference = executionYear;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYearDomainReference;
    }

    public String getYear() {
        return this.getExecutionYear().getYear();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InfoExecutionYear) {
            InfoExecutionYear infoExecutionYear = (InfoExecutionYear)obj;
            return this.getYear().equals(infoExecutionYear.getYear());
        }
        return false;
    }

    public String toString() {
        return this.getExecutionYear().getYear();
    }

    public PeriodState getState() {
        return this.getExecutionYear().getState();
    }

    public int compareTo(Object arg0) {
        InfoExecutionYear infoExecutionYear = (InfoExecutionYear)arg0;
        return this.getYear().compareTo(infoExecutionYear.getYear());
    }

    public Date getBeginDate() {
        return this.getExecutionYear().getBeginDate();
    }

    public Date getEndDate() {
        return this.getExecutionYear().getEndDate();
    }

    public static InfoExecutionYear newInfoFromDomain(ExecutionYear executionYear) {
        return executionYear == null ? null : new InfoExecutionYear(executionYear);
    }

    public String getNextExecutionYearYear() {
        return this.getExecutionYear().getNextYearsYearString();
    }

    public boolean after(InfoExecutionYear infoExecutionYear) {
        return this.getBeginDate().after(infoExecutionYear.getEndDate());
    }

    public InfoExecutionYear getNextInfoExecutionYear() {
        ExecutionYear nextExecutionYear = this.getExecutionYear().getNextExecutionYear();
        return nextExecutionYear == null ? null : InfoExecutionYear.newInfoFromDomain(nextExecutionYear);
    }

    @Override
    public String getExternalId() {
        return this.getExecutionYear().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }
}

