/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.SeniorStatute_Base;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.joda.time.LocalDate;

public class SeniorStatute
extends SeniorStatute_Base {
    private SeniorStatute() {
    }

    public SeniorStatute(Student student, Registration registration, StatuteType statuteType, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        this(student, registration, statuteType, beginExecutionPeriod, endExecutionPeriod, beginExecutionPeriod.getBeginLocalDate(), endExecutionPeriod.getEndLocalDate());
    }

    public SeniorStatute(Student student, Registration registration, StatuteType statuteType, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod, LocalDate beginDate, LocalDate endDate) {
        this();
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setBeginExecutionPeriod(beginExecutionPeriod);
        this.setEndExecutionPeriod(endExecutionPeriod);
        this.setType(statuteType);
        for (StudentStatute statute : student.getStudentStatutesSet()) {
            if (!statute.overlapsWith((StudentStatute)((Object)this)) || !statute.hasSeniorStatuteForRegistration(this.getRegistration())) continue;
            throw new DomainException("error.studentStatute.alreadyExistsOneOverlapingStatute", new String[0]);
        }
        this.setStudent(student);
        if (registration == null) {
            throw new DomainException("error.studentStatute.mustDefineValidRegistrationMatchingSeniorStatute", new String[0]);
        }
        this.setRegistration(registration);
        this.checkRules();
    }

    public void delete() {
        this.checkRulesToDelete();
        this.setBeginExecutionPeriod(null);
        this.setEndExecutionPeriod(null);
        this.setStudent(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean hasSeniorStatuteForRegistration(Registration registration) {
        return this.getRegistration() == registration;
    }
}

