/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.EventSpaceOccupation_Base;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;

public abstract class EventSpaceOccupation
extends EventSpaceOccupation_Base {
    public static final Comparator<EventSpaceOccupation> COMPARATOR_BY_BEGIN_DATE = new ComparatorChain();
    private static int SATURDAY_IN_JODA_TIME;
    private static int SUNDAY_IN_JODA_TIME;
    private static transient Locale locale;

    public abstract Boolean getDailyFrequencyMarkSaturday();

    public abstract Boolean getDailyFrequencyMarkSunday();

    public abstract YearMonthDay getBeginDate();

    public abstract YearMonthDay getEndDate();

    public abstract HourMinuteSecond getStartTimeDateHourMinuteSecond();

    public abstract HourMinuteSecond getEndTimeDateHourMinuteSecond();

    public abstract DiaSemana getDayOfWeek();

    public abstract FrequencyType getFrequency();

    protected EventSpaceOccupation() {
    }

    public void setResource(Space resource) {
        if (!SpaceUtils.isRoom(resource) && !SpaceUtils.isRoomSubdivision(resource)) {
            throw new DomainException("error.EventSpaceOccupation.invalid.resource", new String[0]);
        }
        this.getSpaceSet().clear();
        super.addSpace(resource);
    }

    public Space getRoom() {
        return this.getSpace();
    }

    public Calendar getStartTime() {
        Date date;
        HourMinuteSecond hms = this.getStartTimeDateHourMinuteSecond();
        Date date2 = date = hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
        if (date != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(date);
            return result;
        }
        return null;
    }

    public Calendar getEndTime() {
        Date date;
        HourMinuteSecond hms = this.getEndTimeDateHourMinuteSecond();
        Date date2 = date = hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
        if (date != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(date);
            return result;
        }
        return null;
    }

    protected boolean intersects(YearMonthDay startDate, YearMonthDay endDate) {
        return this.getBeginDate() != null && this.getEndDate() != null && !this.getBeginDate().isAfter((ReadablePartial)endDate) && !this.getEndDate().isBefore((ReadablePartial)startDate);
    }

    public boolean alreadyWasOccupiedBy(EventSpaceOccupation occupation) {
        if (this.equals((Object)occupation)) {
            return true;
        }
        if (occupation.isLessonInstanceSpaceOccupation() || occupation.isWrittenEvaluationSpaceOccupation() || this.intersects(occupation.getBeginDate(), occupation.getEndDate())) {
            List<Interval> thisOccupationIntervals = this.getEventSpaceOccupationIntervals(occupation.getBeginDate(), occupation.getEndDate());
            List<Interval> passedOccupationIntervals = occupation.getEventSpaceOccupationIntervals((YearMonthDay)null, (YearMonthDay)null);
            for (Interval interval : thisOccupationIntervals) {
                for (Interval passedInterval : passedOccupationIntervals) {
                    if (!interval.getStart().isBefore((ReadableInstant)passedInterval.getEnd()) || !interval.getEnd().isAfter((ReadableInstant)passedInterval.getStart())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isWrittenEvaluationSpaceOccupation() {
        return this instanceof WrittenEvaluationSpaceOccupation;
    }

    private boolean isLessonInstanceSpaceOccupation() {
        return this instanceof LessonInstanceSpaceOccupation;
    }

    public boolean alreadyWasOccupiedIn(YearMonthDay startDate, YearMonthDay endDate, HourMinuteSecond startTime, HourMinuteSecond endTime, DiaSemana dayOfWeek, FrequencyType frequency, Boolean dailyFrequencyMarkSaturday, Boolean dailyFrequencyMarkSunday) {
        startTime.setSecondOfMinute(0);
        endTime.setSecondOfMinute(0);
        if (this.intersects(startDate, endDate)) {
            List<Interval> thisOccupationIntervals = this.getEventSpaceOccupationIntervals(startDate, endDate);
            List<Interval> passedOccupationIntervals = EventSpaceOccupation.generateEventSpaceOccupationIntervals(startDate, endDate, startTime, endTime, frequency, dayOfWeek, dailyFrequencyMarkSaturday, dailyFrequencyMarkSunday, null, null);
            for (Interval interval : thisOccupationIntervals) {
                for (Interval passedInterval : passedOccupationIntervals) {
                    if (!interval.getStart().isBefore((ReadableInstant)passedInterval.getEnd()) || !interval.getEnd().isAfter((ReadableInstant)passedInterval.getStart())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Boolean overlaps(List<Interval> intervals) {
        return this.overlaps(intervals.toArray(new Interval[0]));
    }

    public boolean overlaps(Interval ... intervals) {
        for (Interval interval : intervals) {
            if (!this.overlaps(interval)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean overlaps(Interval var1);

    public List<Interval> getEventSpaceOccupationIntervals(DateTime start, DateTime end) {
        Interval i = new Interval((ReadableInstant)start, (ReadableInstant)end);
        List<Interval> intervals = this.getEventSpaceOccupationIntervals(start.toYearMonthDay(), end.toYearMonthDay());
        Iterator<Interval> iterator = intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            if (interval.overlaps((ReadableInterval)i)) continue;
            iterator.remove();
        }
        return intervals;
    }

    public List<Interval> getIntervals() {
        return this.getEventSpaceOccupationIntervals((YearMonthDay)null, (YearMonthDay)null);
    }

    public List<Interval> getEventSpaceOccupationIntervals(YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        return EventSpaceOccupation.generateEventSpaceOccupationIntervals(this.getBeginDate(), this.getEndDate(), this.getStartTimeDateHourMinuteSecond(), this.getEndTimeDateHourMinuteSecond(), this.getFrequency(), this.getDayOfWeek(), this.getDailyFrequencyMarkSaturday(), this.getDailyFrequencyMarkSunday(), startDateToSearch, endDateToSearch);
    }

    public static List<Interval> generateEventSpaceOccupationIntervals(YearMonthDay begin, YearMonthDay end, HourMinuteSecond beginTime, HourMinuteSecond endTime, FrequencyType frequency, DiaSemana diaSemana, Boolean dailyFrequencyMarkSaturday, Boolean dailyFrequencyMarkSunday, YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        begin = EventSpaceOccupation.getBeginDateInSpecificWeekDay(diaSemana, begin);
        if (frequency == null) {
            if (!(begin.isAfter((ReadablePartial)end) || startDateToSearch != null && (end.isBefore((ReadablePartial)startDateToSearch) || begin.isAfter((ReadablePartial)endDateToSearch)))) {
                result.add(EventSpaceOccupation.createNewInterval(begin, end, beginTime, endTime));
                return result;
            }
        } else {
            int numberOfDaysToSum = frequency.getNumberOfDays();
            while (!begin.isAfter((ReadablePartial)end)) {
                if (startDateToSearch == null || !begin.isBefore((ReadablePartial)startDateToSearch) && !begin.isAfter((ReadablePartial)endDateToSearch)) {
                    Interval interval = EventSpaceOccupation.createNewInterval(begin, begin, beginTime, endTime);
                    if (!frequency.equals((Object)FrequencyType.DAILY) || (dailyFrequencyMarkSaturday.booleanValue() || interval.getStart().getDayOfWeek() != SATURDAY_IN_JODA_TIME) && (dailyFrequencyMarkSunday.booleanValue() || interval.getStart().getDayOfWeek() != SUNDAY_IN_JODA_TIME)) {
                        result.add(interval);
                    }
                }
                begin = begin.plusDays(numberOfDaysToSum);
            }
        }
        return result;
    }

    protected DateTime getInstant(boolean firstInstant, YearMonthDay begin, YearMonthDay end, HourMinuteSecond beginTime, HourMinuteSecond endTime, FrequencyType frequency, DiaSemana diaSemana, Boolean dailyFrequencyMarkSaturday, Boolean dailyFrequencyMarkSunday) {
        DateTime instantResult = null;
        begin = EventSpaceOccupation.getBeginDateInSpecificWeekDay(diaSemana, begin);
        if (frequency == null) {
            if (!begin.isAfter((ReadablePartial)end)) {
                if (firstInstant) {
                    return begin.toDateTime(new TimeOfDay(beginTime.getHour(), beginTime.getMinuteOfHour(), 0, 0));
                }
                return end.toDateTime(new TimeOfDay(endTime.getHour(), endTime.getMinuteOfHour(), 0, 0));
            }
        } else {
            int numberOfDaysToSum = frequency.getNumberOfDays();
            while (!begin.isAfter((ReadablePartial)end)) {
                DateTime intervalEnd = begin.toDateTime(new TimeOfDay(endTime.getHour(), endTime.getMinuteOfHour(), 0, 0));
                if (!frequency.equals((Object)FrequencyType.DAILY) || (dailyFrequencyMarkSaturday.booleanValue() || intervalEnd.getDayOfWeek() != SATURDAY_IN_JODA_TIME) && (dailyFrequencyMarkSunday.booleanValue() || intervalEnd.getDayOfWeek() != SUNDAY_IN_JODA_TIME)) {
                    if (firstInstant) {
                        return begin.toDateTime(new TimeOfDay(beginTime.getHour(), beginTime.getMinuteOfHour(), 0, 0));
                    }
                    instantResult = intervalEnd;
                }
                begin = begin.plusDays(numberOfDaysToSum);
            }
        }
        return instantResult;
    }

    private static YearMonthDay getBeginDateInSpecificWeekDay(DiaSemana diaSemana, YearMonthDay begin) {
        if (diaSemana != null) {
            YearMonthDay newBegin = begin.toDateTimeAtMidnight().withDayOfWeek(diaSemana.getDiaSemanaInDayOfWeekJodaFormat()).toYearMonthDay();
            begin = newBegin.isBefore((ReadablePartial)begin) ? newBegin.plusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK) : newBegin;
        }
        return begin;
    }

    protected static Interval createNewInterval(YearMonthDay begin, YearMonthDay end, HourMinuteSecond beginTime, HourMinuteSecond endTime) {
        return new Interval((ReadableInstant)begin.toDateTime(new TimeOfDay(beginTime.getHour(), beginTime.getMinuteOfHour(), 0, 0)), (ReadableInstant)end.toDateTime(new TimeOfDay(endTime.getHour(), endTime.getMinuteOfHour(), 0, 0)));
    }

    public DateTime getFirstInstant() {
        return this.getInstant(true, this.getBeginDate(), this.getEndDate(), this.getStartTimeDateHourMinuteSecond(), this.getEndTimeDateHourMinuteSecond(), this.getFrequency(), this.getDayOfWeek(), this.getDailyFrequencyMarkSaturday(), this.getDailyFrequencyMarkSunday());
    }

    public DateTime getLastInstant() {
        return this.getInstant(false, this.getBeginDate(), this.getEndDate(), this.getStartTimeDateHourMinuteSecond(), this.getEndTimeDateHourMinuteSecond(), this.getFrequency(), this.getDayOfWeek(), this.getDailyFrequencyMarkSaturday(), this.getDailyFrequencyMarkSunday());
    }

    public String getPrettyPrint() {
        StringBuilder builder = new StringBuilder();
        if (this.getFrequency() == null) {
            builder.append(this.getBeginDate().toString("dd/MM/yyyy")).append(" ").append(this.getPresentationBeginTime());
            builder.append(" - ").append(this.getEndDate().toString("dd/MM/yyyy")).append(" ").append(this.getPresentationEndTime());
        } else {
            builder.append(this.getBeginDate().toString("dd/MM/yyyy")).append(" - ").append(this.getEndDate().toString("dd/MM/yyyy"));
            builder.append(" (").append(this.getPresentationBeginTime()).append(" - ").append(this.getPresentationEndTime()).append(")");
        }
        return builder.toString();
    }

    public String getSubject() {
        return this.getPresentationString();
    }

    public String getPresentationString() {
        return "";
    }

    public String getPresentationBeginTime() {
        return this.getStartTimeDateHourMinuteSecond().toString("HH:mm");
    }

    public String getPresentationEndTime() {
        return this.getEndTimeDateHourMinuteSecond().toString("HH:mm");
    }

    public String getPresentationBeginDate() {
        return this.getBeginDate().toString("dd MMMM yyyy", locale) + " (" + this.getBeginDate().toDateTimeAtMidnight().toString("E", locale) + ")";
    }

    public String getPresentationEndDate() {
        return this.getEndDate().toString("dd MMMM yyyy", locale) + " (" + this.getEndDate().toDateTimeAtMidnight().toString("E", locale) + ")";
    }

    public abstract boolean isOccupiedByExecutionCourse(ExecutionCourse var1, DateTime var2, DateTime var3);

    public void delete() {
        this.setBennu(null);
        this.getSpaceSet().clear();
        super.deleteDomainObject();
    }

    static {
        ((ComparatorChain)COMPARATOR_BY_BEGIN_DATE).addComparator((Comparator)new BeanComparator("period.startDate"));
        ((ComparatorChain)COMPARATOR_BY_BEGIN_DATE).addComparator((Comparator)new BeanComparator("externalId"));
        SATURDAY_IN_JODA_TIME = 6;
        SUNDAY_IN_JODA_TIME = 7;
        locale = I18N.getLocale();
    }
}

