/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestCategory;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$create;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$create$1;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$createLegacy;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$delete;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$edit$1;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ServiceRequestType
extends ServiceRequestType_Base {
    public static final Comparator<ServiceRequestType> COMPARE_BY_CATEGORY_THEN_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$edit$1;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$create$1;
    public static final Advice advice$createLegacy;

    protected ServiceRequestType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected ServiceRequestType(String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, ServiceRequestCategory category) {
        this();
        super.setCode(code);
        super.setName(name);
        this.setActive(active);
        this.setPayable(payable);
        this.setNotifyUponConclusion(notifyUponConclusion);
        this.setPrintable(printable);
        this.setRequestedOnline(requestedOnline);
        this.setServiceRequestCategory(category);
        this.checkRules();
    }

    protected ServiceRequestType(String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, Boolean printableOnline, ServiceRequestCategory category) {
        this();
        super.setCode(code);
        super.setName(name);
        this.setActive(active);
        this.setPayable(payable);
        this.setNotifyUponConclusion(notifyUponConclusion);
        this.setPrintable(printable);
        this.setRequestedOnline(requestedOnline);
        this.setPrintableOnline(printableOnline);
        this.setServiceRequestCategory(category);
        this.checkRules();
    }

    protected ServiceRequestType(String code, LocalizedString name, boolean active, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, ServiceRequestCategory category) {
        this(code, name, active, payable, notifyUponConclusion, printable, requestedOnline, category);
        this.setAcademicServiceRequestType(academicServiceRequestType);
        this.setDocumentRequestType(documentRequestType);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getCode().trim().isEmpty()) {
            throw new DomainException("error.ServiceRequestType.code.empty", new String[0]);
        }
        if (this.getName().isEmpty()) {
            throw new DomainException("error.ServiceRequestType.name.empty", new String[0]);
        }
        if (this.getServiceRequestCategory() == null) {
            throw new DomainException("error.ServiceRequestType.category.empty", new String[0]);
        }
        if (ServiceRequestType.findByCode(this.getCode()).count() > 1L) {
            throw new DomainException("error.ServiceRequestType.code.duplicated", new String[0]);
        }
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isPayable() {
        return this.getPayable();
    }

    public boolean isToNotifyUponConclusion() {
        return this.getNotifyUponConclusion() == null ? false : this.getNotifyUponConclusion();
    }

    public boolean isPrintable() {
        return this.getPrintable() == null ? false : this.getPrintable();
    }

    public boolean isRequestedOnline() {
        return this.getRequestedOnline() == null ? false : this.getRequestedOnline();
    }

    public boolean isPrintableOnline() {
        return this.getPrintableOnline() == null ? false : this.getPrintableOnline();
    }

    public boolean isLegacy() {
        return this.getAcademicServiceRequestType() != null;
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, ServiceRequestCategory serviceRequestCategory, LocalizedString localizedString2) {
        Object object = advice$edit.perform((Callable)new ServiceRequestType$callable$edit(this, string, localizedString, bl, bl2, bl3, bl4, bl5, serviceRequestCategory, localizedString2));
    }

    static /* synthetic */ void advised$edit(ServiceRequestType this_, String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, ServiceRequestCategory category, LocalizedString numberOfUnitsLabel) {
        this_.setCode(code);
        this_.setName(name);
        this_.setActive(active);
        this_.setPayable(payable);
        this_.setNotifyUponConclusion(notifyUponConclusion);
        this_.setPrintable(printable);
        this_.setRequestedOnline(requestedOnline);
        this_.setServiceRequestCategory(category);
        this_.setNumberOfUnitsLabel(null);
        this_.checkRules();
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, ServiceRequestCategory serviceRequestCategory, LocalizedString localizedString2) {
        Object object = advice$edit$1.perform((Callable)new ServiceRequestType$callable$edit$1(this, string, localizedString, bl, bl2, bl3, bl4, bl5, bl6, serviceRequestCategory, localizedString2));
    }

    static /* synthetic */ void advised$edit(ServiceRequestType this_, String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, Boolean printableOnline, ServiceRequestCategory category, LocalizedString numberOfUnitsLabel) {
        this_.setCode(code);
        this_.setName(name);
        this_.setActive(active);
        this_.setPayable(payable);
        this_.setNotifyUponConclusion(notifyUponConclusion);
        this_.setPrintable(printable);
        this_.setRequestedOnline(requestedOnline);
        this_.setPrintableOnline(printableOnline);
        this_.setServiceRequestCategory(category);
        this_.setNumberOfUnitsLabel(null);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        if (this.getAcademicServiceRequestsSet().size() != 1) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.ServiceRequestType.academicServiceRequestsSet.not.empty", (String[])new String[0]));
        }
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ServiceRequestType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ServiceRequestType this_) {
        DomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Stream<ServiceRequestType> findAll() {
        return Bennu.getInstance().getServiceRequestTypesSet().stream();
    }

    public static ServiceRequestType findUnique(AcademicServiceRequestType academicServiceRequestType) {
        return ServiceRequestType.findAll().filter(x -> x.getAcademicServiceRequestType() != null && x.getAcademicServiceRequestType().equals((Object)academicServiceRequestType)).filter(x -> x.getDocumentRequestType() == null).findFirst().orElse(null);
    }

    public static ServiceRequestType findUnique(AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType) {
        return ServiceRequestType.findAll().filter(s -> s.getAcademicServiceRequestType() == academicServiceRequestType && s.getDocumentRequestType() == documentRequestType).findFirst().orElse(null);
    }

    public static ServiceRequestType findUnique(AcademicServiceRequest academicServiceRequest) {
        if (academicServiceRequest.getServiceRequestType() != null) {
            return academicServiceRequest.getServiceRequestType();
        }
        if (academicServiceRequest.isDocumentRequest()) {
            return ServiceRequestType.findUnique(academicServiceRequest.getAcademicServiceRequestType(), ((DocumentRequest)((Object)academicServiceRequest)).getDocumentRequestType());
        }
        return ServiceRequestType.findUnique(academicServiceRequest.getAcademicServiceRequestType());
    }

    public static Stream<ServiceRequestType> findByCode(String code) {
        return ServiceRequestType.findAll().filter(l -> l.getCode().equalsIgnoreCase(code));
    }

    public static Optional<ServiceRequestType> findUniqueByCode(String code) {
        return ServiceRequestType.findByCode(code).findFirst();
    }

    public static Stream<ServiceRequestType> findActive() {
        return ServiceRequestType.findAll().filter(ServiceRequestType::isActive);
    }

    public static Stream<ServiceRequestType> findDeclarations() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.DECLARATIONS);
    }

    public static Stream<ServiceRequestType> findCertificates() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.CERTIFICATES);
    }

    public static Stream<ServiceRequestType> findServices() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.SERVICES);
    }

    public static ServiceRequestType create(String string, LocalizedString localizedString, boolean bl, boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, ServiceRequestCategory serviceRequestCategory) {
        return (ServiceRequestType)((Object)advice$create.perform((Callable)new ServiceRequestType$callable$create(string, localizedString, bl, bl2, bl3, bl4, bl5, serviceRequestCategory)));
    }

    static /* synthetic */ ServiceRequestType advised$create(String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, ServiceRequestCategory category) {
        return new ServiceRequestType(code, name, active, payable, notifyUponConclusion, printable, requestedOnline, category);
    }

    public static ServiceRequestType create(String string, LocalizedString localizedString, boolean bl, boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, ServiceRequestCategory serviceRequestCategory) {
        return (ServiceRequestType)((Object)advice$create$1.perform((Callable)new ServiceRequestType$callable$create$1(string, localizedString, bl, bl2, bl3, bl4, bl5, bl6, serviceRequestCategory)));
    }

    static /* synthetic */ ServiceRequestType advised$create(String code, LocalizedString name, boolean active, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, Boolean printableOnline, ServiceRequestCategory category) {
        return new ServiceRequestType(code, name, active, payable, notifyUponConclusion, printable, requestedOnline, printableOnline, category);
    }

    public static ServiceRequestType createLegacy(String string, LocalizedString localizedString, boolean bl, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, ServiceRequestCategory serviceRequestCategory) {
        return (ServiceRequestType)((Object)advice$createLegacy.perform((Callable)new ServiceRequestType$callable$createLegacy(string, localizedString, bl, academicServiceRequestType, documentRequestType, bl2, bl3, bl4, bl5, serviceRequestCategory)));
    }

    static /* synthetic */ ServiceRequestType advised$createLegacy(String code, LocalizedString name, boolean active, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean payable, Boolean notifyUponConclusion, Boolean printable, Boolean requestedOnline, ServiceRequestCategory category) {
        return new ServiceRequestType(code, name, active, academicServiceRequestType, documentRequestType, payable, notifyUponConclusion, printable, requestedOnline, category);
    }

    public String getRichName() {
        return this.getName().getContent() + " (" + BundleUtil.getString((String)"resources.StudentResources", (String)(this.isPayable() ? "label.student.serviceRequestTypes.withFees" : "label.student.serviceRequestTypes.noFees"), (String[])new String[0]) + ")";
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$edit$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createLegacy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_CATEGORY_THEN_BY_NAME = new Comparator<ServiceRequestType>(){

            @Override
            public int compare(ServiceRequestType o1, ServiceRequestType o2) {
                if (o1.getServiceRequestCategory() == null) {
                    return -1;
                }
                if (o2.getServiceRequestCategory() == null) {
                    return 1;
                }
                int c = o1.getServiceRequestCategory().compareTo(o2.getServiceRequestCategory());
                return c == 0 ? o1.getName().getContent().compareTo(o2.getName().getContent()) : c;
            }
        };
    }
}

