/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.reports.RaidesCommonReportFieldsWrapper;
import org.fenixedu.academic.domain.reports.RaidesGraduationReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaidesGraduationReportFile
extends RaidesGraduationReportFile_Base {
    private static final Logger logger = LoggerFactory.getLogger(RaidesGraduationReportFile.class);

    public String getJobName() {
        return "Listagem RAIDES - Gradua\u00e7\u00e3o";
    }

    protected String getPrefix() {
        return "graduationRAIDES";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        ExecutionYear executionYear = this.getExecutionYear();
        this.createHeaders(spreadsheet);
        logger.info("BEGIN report for " + this.getDegreeType().getName().getContent());
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansToProcess(executionYear)) {
            Registration registration = studentCurricularPlan.getRegistration();
            if (registration == null || registration.isTransition() || registration.isSchoolPartConcluded()) continue;
            for (CycleType cycleType : registration.getDegreeType().getCycleTypes()) {
                ExecutionYear conclusionYear;
                CycleCurriculumGroup cycleCGroup = studentCurricularPlan.getRoot().getCycleCurriculumGroup(cycleType);
                if (cycleCGroup == null || cycleCGroup.isExternal()) continue;
                RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(registration, (CurriculumGroup)((Object)cycleCGroup));
                if (cycleCGroup.isConcluded() && (conclusionYear = registrationConclusionBean.getConclusionYear()) != executionYear && conclusionYear != executionYear.getPreviousExecutionYear()) continue;
                boolean isToAddRegistration = false;
                for (RegistrationState state : registration.getRegistrationStates(executionYear)) {
                    if (!state.isActive() && state.getStateType() != RegistrationStateType.CONCLUDED) continue;
                    isToAddRegistration = true;
                    break;
                }
                if (isToAddRegistration && cycleCGroup.isConcluded(executionYear.getPreviousExecutionYear()) == CurriculumModule.ConclusionValue.CONCLUDED) {
                    this.reportRaidesGraduate(spreadsheet, registration, RaidesGraduationReportFile.getFullRegistrationPath((Registration)registration), executionYear, cycleType, true, registrationConclusionBean.getConclusionDate(), registrationConclusionBean.getRawGrade().getNumericValue());
                    continue;
                }
                if (!isToAddRegistration || !registration.getLastDegreeCurricularPlan().hasExecutionDegreeFor(executionYear)) continue;
                this.reportRaidesGraduate(spreadsheet, registration, RaidesGraduationReportFile.getFullRegistrationPath((Registration)registration), executionYear, cycleType, false, null, registrationConclusionBean.getRawGrade().getNumericValue());
            }
        }
        logger.info("END report for " + this.getDegreeType().getName().getContent());
    }

    private Set<StudentCurricularPlan> getStudentCurricularPlansToProcess(ExecutionYear executionYear) {
        HashSet<StudentCurricularPlan> result = new HashSet<StudentCurricularPlan>();
        this.collectStudentCurricularPlansFor(executionYear, result);
        if (executionYear.getPreviousExecutionYear() != null) {
            this.collectStudentCurricularPlansFor(executionYear.getPreviousExecutionYear(), result);
        }
        return result;
    }

    private void collectStudentCurricularPlansFor(ExecutionYear executionYear, Set<StudentCurricularPlan> result) {
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesByType(this.getDegreeType())) {
            for (StudentCurricularPlan studentCurricularPlan : executionDegree.getDegreeCurricularPlan().getStudentCurricularPlansSet()) {
                if (studentCurricularPlan.getStartDateYearMonthDay().isAfter((ReadablePartial)executionYear.getEndDateYearMonthDay())) continue;
                result.add(studentCurricularPlan);
            }
        }
    }

    private void createHeaders(Spreadsheet spreadsheet) {
        RaidesCommonReportFieldsWrapper.createHeaders(spreadsheet);
    }

    private void reportRaidesGraduate(Spreadsheet sheet, Registration registration, List<Registration> registrationPath, ExecutionYear executionYear, CycleType cycleType, boolean concluded, YearMonthDay conclusionDate, BigDecimal average) {
        RaidesCommonReportFieldsWrapper.reportRaidesFields(sheet, registration, registrationPath, executionYear, cycleType, concluded, conclusionDate, average, true);
    }
}

