/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests.documentRequests;

import java.util.Locale;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.EctsGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.degreeStructure.NoEctsComparabilityTableFound;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramInformation;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaSupplementRequest_Base;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRectorateSubmissionBatchDocumentEntry;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.DiplomaSupplement;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdDiplomaSupplementRequest
extends PhdDiplomaSupplementRequest_Base
implements IDiplomaSupplementRequest,
IRectorateSubmissionBatchDocumentEntry {
    protected PhdDiplomaSupplementRequest() {
    }

    protected PhdDiplomaSupplementRequest(PhdDocumentRequestCreateBean bean) {
        this();
        this.init(bean);
    }

    protected void init(PhdAcademicServiceRequestCreateBean bean) {
        throw new DomainException("invoke init(PhdDocumentRequestCreateBean)", new String[0]);
    }

    protected void init(PhdDocumentRequestCreateBean bean) {
        super.init(bean);
        this.checkParameters(bean);
        this.getPhdIndividualProgramProcess().getPerson().getProfile().changeName(bean.getGivenNames(), bean.getFamilyNames(), null);
    }

    private void checkParameters(PhdDocumentRequestCreateBean bean) {
        String composedName;
        String fullName = this.getPhdIndividualProgramProcess().getStudent().getPerson().getName();
        String familyName = bean.getFamilyNames();
        String string = composedName = familyName == null || familyName.isEmpty() ? bean.getGivenNames() : bean.getGivenNames() + " " + familyName;
        if (!fullName.equals(composedName)) {
            throw new DomainException("error.diplomaSupplementRequest.splittedNamesDoNotMatch", new String[0]);
        }
        PhdIndividualProgramProcess process2 = this.getPhdIndividualProgramProcess();
        if (!process2.hasRegistryDiplomaRequest() && process2.hasDiplomaRequest()) {
            throw new DomainException("error.diplomaSupplementRequest.cannotAskForSupplementWithoutEitherRegistryDiplomaOrDiplomaRequest", new String[0]);
        }
        PhdDiplomaSupplementRequest supplement = process2.getDiplomaSupplementRequest();
        if (supplement != null && supplement != this) {
            throw new DomainException("error.diplomaSupplementRequest.alreadyRequested", new String[0]);
        }
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return true;
    }

    @Override
    public EventType getEventType() {
        return null;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    @Override
    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST;
    }

    @Override
    public String getDocumentTemplateKey() {
        return DiplomaSupplement.class.getName();
    }

    @Override
    public CycleType getRequestedCycle() {
        return CycleType.THIRD_CYCLE;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        try {
            this.verifyIsToProcessAndHasPersonalInfo(academicServiceRequestBean);
            this.verifyIsToDeliveredAndIsPayed(academicServiceRequestBean);
        }
        catch (DomainException e) {
            throw new PhdDomainOperationException(e.getKey(), (Throwable)((Object)e), e.getArgs());
        }
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            if (!this.getPhdIndividualProgramProcess().isConcluded()) {
                throw new PhdDomainOperationException("error.phdDiplomaSupplement.registration.not.submited.to.conclusion.process", new String[0]);
            }
            if (this.getRegistryCode() == null) {
                this.getRegistryDiplomaRequest().getRegistryCode().addDocumentRequest((AcademicServiceRequest)((Object)this));
                this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
        }
    }

    public static PhdDiplomaSupplementRequest create(PhdDocumentRequestCreateBean bean) {
        return new PhdDiplomaSupplementRequest(bean);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType(), "DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST.THIRD_CYCLE");
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getPhdIndividualProgramProcess().getGraduateTitle(locale);
    }

    @Override
    public Integer getRegistrationNumber() {
        return this.getStudent().getNumber();
    }

    @Override
    public String getPrevailingScientificArea(Locale locale) {
        return this.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent(locale);
    }

    @Override
    public double getEctsCredits() {
        PhdProgramInformation information = this.getPhdInformationForConclusionDate();
        if (information == null) {
            return 0.0;
        }
        return information.getMaxStudyPlanEctsCredits().add(information.getMaxThesisEctsCredits()).doubleValue();
    }

    @Override
    public DegreeOfficialPublication getDegreeOfficialPublication() {
        PhdConclusionProcess lastConclusionProcess = this.getPhdIndividualProgramProcess().getLastConclusionProcess();
        DateTime conclusionDate = null;
        if (!this.getPhdIndividualProgramProcess().getStudyPlan().isExempted()) {
            Registration registration = this.getPhdIndividualProgramProcess().getRegistration();
            conclusionDate = registration.getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getConclusionDate().toDateMidnight().toDateTime();
        } else {
            conclusionDate = lastConclusionProcess.getConclusionDate().toDateMidnight().toDateTime();
        }
        return this.getPhdIndividualProgramProcess().getPhdProgram().getDegree().getOfficialPublication(conclusionDate);
    }

    @Override
    public Integer getFinalAverage() {
        if (this.getPhdIndividualProgramProcess().getStudyPlan().isExempted()) {
            return null;
        }
        return this.getPhdIndividualProgramProcess().getRegistration().getLastStudentCurricularPlan().getCycle(this.getRequestedCycle()).getFinalGrade().getIntegerValue();
    }

    @Override
    public String getFinalAverageQualified(Locale locale) {
        Integer finalGrade = this.getFinalAverage();
        if (finalGrade == null) {
            return null;
        }
        String qualifiedAverageGrade = finalGrade <= 13 ? "sufficient" : (finalGrade <= 15 ? "good" : (finalGrade <= 17 ? "verygood" : "excelent"));
        return "diploma.supplement.qualifiedgrade." + qualifiedAverageGrade;
    }

    public boolean isPiggyBackedOnRegistry() {
        return this.getRegistryDiplomaRequest() != null;
    }

    public String getThesisFinalGrade(Locale locale) {
        PhdThesisFinalGrade finalGrade = this.getPhdIndividualProgramProcess().getFinalGrade();
        return finalGrade.getLocalizedName(locale);
    }

    @Override
    public ExecutionYear getConclusionYear() {
        return this.getPhdIndividualProgramProcess().getConclusionYear();
    }

    @Override
    public EctsGraduationGradeConversionTable getGraduationConversionTable() {
        try {
            return EctsTableIndex.getGraduationGradeConversionTable(this.getPhdIndividualProgramProcess().getPhdProgram().getDegree(), this.getRequestedCycle(), this.getConclusionYear().getAcademicInterval(), this.getProcessingDate());
        }
        catch (NoEctsComparabilityTableFound e) {
            throw new PhdDomainOperationException("error.no.ects.comparability.found", new String[0]);
        }
    }

    @Override
    public Integer getNumberOfCurricularYears() {
        PhdProgramInformation information = this.getPhdInformationForConclusionDate();
        if (information == null) {
            return null;
        }
        return information.getNumberOfYears();
    }

    private PhdProgramInformation getPhdInformationForConclusionDate() {
        LocalDate conclusionDate = null;
        if (!this.getPhdIndividualProgramProcess().getStudyPlan().isExempted()) {
            Registration registration = this.getPhdIndividualProgramProcess().getRegistration();
            conclusionDate = registration.getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getConclusionDate().toDateMidnight().toLocalDate();
        } else {
            PhdConclusionProcess conclusionProcess = this.getPhdIndividualProgramProcess().getLastConclusionProcess();
            conclusionDate = conclusionProcess.getConclusionDate();
        }
        PhdProgram phdProgram = this.getPhdIndividualProgramProcess().getPhdProgram();
        PhdProgramInformation information = phdProgram.getPhdProgramInformationByDate(conclusionDate);
        return information;
    }

    @Override
    public Integer getNumberOfCurricularSemesters() {
        PhdProgramInformation information = this.getPhdInformationForConclusionDate();
        if (information == null) {
            return null;
        }
        return information.getNumberOfSemesters();
    }

    @Override
    public Boolean isExemptedFromStudy() {
        return this.getPhdIndividualProgramProcess().getStudyPlan().isExempted();
    }

    @Override
    public Registration getRegistration() {
        if (this.isExemptedFromStudy().booleanValue()) {
            return null;
        }
        return this.getPhdIndividualProgramProcess().getRegistration();
    }

    @Override
    public boolean hasRegistration() {
        return this.getRegistration() != null;
    }

    @Override
    public String getProgrammeTypeDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"label.php.program", (String[])new String[0]);
    }

    @Override
    public String getViewStudentProgrammeLink() {
        return "/phdIndividualProgramProcess.do?method=viewProcess&amp;processId=" + this.getPhdIndividualProgramProcess().getExternalId();
    }

    @Override
    public String getReceivedActionLink() {
        return String.format("/phdAcademicServiceRequestManagement.do?method=prepareReceiveOnRectorate&amp;phdAcademicServiceRequestId=%s&amp;batchOid=%s", this.getExternalId(), this.getRectorateSubmissionBatch().getExternalId());
    }

    @Override
    public boolean isProgrammeLinkVisible() {
        return this.getPhdIndividualProgramProcess().isCurrentUserAllowedToManageProcess();
    }
}

