/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.reports;

import java.util.List;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder;
import org.fenixedu.academic.domain.phd.reports.PhdReport;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.YearMonthDay;

public class EPFLCandidatesReport
extends PhdReport {
    public EPFLCandidatesReport(HSSFWorkbook workbook) {
        super(workbook);
    }

    public HSSFSheet build(SearchPhdIndividualProgramProcessBean bean) {
        List<PhdIndividualProgramProcess> processes = PhdIndividualProgramProcess.search(bean.getExecutionYear(), bean.getPredicates());
        if (!this.hasEPFLCandidates(processes)) {
            return null;
        }
        HSSFSheet sheet = this.workbook.createSheet("Candidaturas EPFL");
        this.setHeaders(sheet);
        this.setHeaders(sheet);
        int i = 2;
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!this.isProcessFromEPFL(process2) || !process2.isAllowedToManageProcess(Authenticate.getUser())) continue;
            HSSFRow row = sheet.createRow(i);
            this.fillRow(process2, row);
            ++i;
        }
        return sheet;
    }

    private boolean hasEPFLCandidates(List<PhdIndividualProgramProcess> processes) {
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!this.isProcessFromEPFL(process2)) continue;
            return true;
        }
        return false;
    }

    private boolean isProcessFromEPFL(PhdIndividualProgramProcess process2) {
        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod() != null && process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().isEpflCandidacyPeriod() || PhdIndividualProgramCollaborationType.EPFL == process2.getCollaborationType();
    }

    private void fillRow(PhdIndividualProgramProcess process2, HSSFRow row) {
        String processNumber = process2.getProcessNumber();
        String studentNumber = process2.getStudent() != null ? process2.getStudent().getNumber().toString() : "";
        String studentName = process2.getPerson().getName();
        YearMonthDay dateOfBirth = process2.getPerson().getDateOfBirthYearMonthDay();
        String documentIdNumber = process2.getPerson().getDocumentIdNumber();
        String documentIdTypeName = process2.getPerson().getIdDocumentType().getLocalizedName();
        String phdProgramName = process2.getPhdProgram() != null ? process2.getPhdProgram().getName().getContent() : "";
        String focusArea = process2.getPhdProgramFocusArea() != null ? process2.getPhdProgramFocusArea().getName().getContent() : "";
        String externalPhdProgram = process2.getExternalPhdProgram() != null ? process2.getExternalPhdProgram().getName().getContent() : "";
        this.addCellValue(row, this.onNullEmptyString(processNumber), 0);
        this.addCellValue(row, this.onNullEmptyString(studentNumber), 1);
        this.addCellValue(row, this.onNullEmptyString(studentName), 2);
        this.addCellValue(row, this.onNullEmptyString(dateOfBirth), 3);
        this.addCellValue(row, this.onNullEmptyString(documentIdNumber), 4);
        this.addCellValue(row, this.onNullEmptyString(documentIdTypeName), 5);
        this.addCellValue(row, this.onNullEmptyString(focusArea), 6);
        this.addCellValue(row, this.onNullEmptyString(phdProgramName), 7);
        this.addCellValue(row, this.onNullEmptyString(externalPhdProgram), 8);
        int column = 9;
        Set thesisSubjectOrdersSet = process2.getThesisSubjectOrdersSet();
        for (ThesisSubjectOrder thesisSubjectOrder : thesisSubjectOrdersSet) {
            this.addCellValue(row, this.onNullEmptyString(thesisSubjectOrder.getThesisSubject().getName().getContent()), column++);
        }
    }

    @Override
    protected void setHeaders(HSSFSheet sheet) {
        this.addHeaderCell(sheet, this.getHeaderInBundle("processNumber"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumber"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("dateOfBirth"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("identification"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("idDocumentType"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("focusArea"), 6);
        this.addHeaderCell(sheet, this.getHeaderInBundle("phdProgram"), 7);
        this.addHeaderCell(sheet, this.getHeaderInBundle("epfl.phdProgram"), 8);
        this.addHeaderCell(sheet, this.getHeaderInBundle("thesis.rank"), 9);
    }

    private String getHeaderInBundle(String field) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)("label.org.fenixedu.academic.domain.phd.reports.PhdIndividualProgramProcessesReport." + field), (String[])new String[0]);
    }
}

