/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualPersonalDataBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualPersonalData_Base;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.BirthdayMismatchException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.GivenNameMismatchException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.MultiplePersonFoundByDocumentIdException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PersonNotFoundException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PersonSearchByNameMismatchException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PossiblePersonCandidatesException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.SocialSecurityNumberMismatchException;
import org.fenixedu.academic.dto.person.PersonBean;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class PhdMigrationIndividualPersonalData
extends PhdMigrationIndividualPersonalData_Base {
    protected PhdMigrationIndividualPersonalData(String data) {
        this.setData(data);
    }

    public PhdMigrationIndividualPersonalDataBean getPersonalBean() {
        return new PhdMigrationIndividualPersonalDataBean(this.getData());
    }

    public void parse() {
        this.getPersonalBean();
    }

    public void parseAndSetNumber() {
        PhdMigrationIndividualPersonalDataBean personalBean = this.getPersonalBean();
        this.setNumber(personalBean.getPhdStudentNumber());
    }

    public Person getPerson() {
        if (this.getPersonalBean().hasChosenPersonManually()) {
            return this.getPersonalBean().getChosenPersonManually();
        }
        Collection<Person> personSet = Person.readByDocumentIdNumber(this.getPersonalBean().getIdentificationNumber());
        Collection<Person> personNamesSet = Person.findPerson(this.getPersonalBean().getFullName());
        if (personSet.isEmpty() && personNamesSet.isEmpty()) {
            throw new PersonNotFoundException();
        }
        if (personSet.size() > 1) {
            throw new MultiplePersonFoundByDocumentIdException(this.getPersonalBean().getIdentificationNumber());
        }
        if (personSet.isEmpty()) {
            this.checkPossibleCandidates(personNamesSet);
        }
        this.checkPersonByIdDocument(personSet, personNamesSet);
        Person person = personSet.iterator().next();
        if (!StringUtils.isEmpty((String)this.getPersonalBean().getSocialSecurityNumber()) && !StringUtils.isEmpty((String)person.getSocialSecurityNumber()) && this.getPersonalBean().getSocialSecurityNumber().equals(person.getSocialSecurityNumber())) {
            return person;
        }
        if (!StringUtils.isEmpty((String)this.getPersonalBean().getSocialSecurityNumber()) && !StringUtils.isEmpty((String)person.getSocialSecurityNumber())) {
            throw new SocialSecurityNumberMismatchException("Original: " + this.getPersonalBean().getSocialSecurityNumber() + " Differs from: " + person.getSocialSecurityNumber());
        }
        if (person.getDateOfBirthYearMonthDay() == null || !person.getDateOfBirthYearMonthDay().isEqual((ReadablePartial)this.getPersonalBean().getDateOfBirth())) {
            throw new BirthdayMismatchException("Original: " + this.getPersonalBean().getDateOfBirth() + " Differs from: " + person.getDateOfBirthYearMonthDay());
        }
        return person;
    }

    private Person checkPersonByIdDocument(Collection<Person> personSet, Collection<Person> personNamesSet) {
        Person possiblePerson = personSet.iterator().next();
        for (Person person : personNamesSet) {
            if (person != possiblePerson) continue;
            return possiblePerson;
        }
        throw new PersonSearchByNameMismatchException(new HashSet<Person>(personNamesSet));
    }

    private void checkPossibleCandidates(Collection<Person> personNamesSet) {
        HashSet<Person> possiblePersonSet = new HashSet<Person>();
        for (Person person : personNamesSet) {
            if (StringUtils.isEmpty((String)person.getSocialSecurityNumber()) || !person.getSocialSecurityNumber().equals(this.getPersonalBean().getSocialSecurityNumber()) || person.getDateOfBirthYearMonthDay() == null || !person.getDateOfBirthYearMonthDay().isEqual((ReadablePartial)this.getPersonalBean().getDateOfBirth())) continue;
            possiblePersonSet.add(person);
        }
        if (!possiblePersonSet.isEmpty()) {
            throw new PossiblePersonCandidatesException(possiblePersonSet);
        }
        throw new PersonNotFoundException();
    }

    public boolean isPersonRegisteredOnFenix() {
        try {
            return this.getPerson() != null;
        }
        catch (PersonNotFoundException e) {
            return false;
        }
    }

    public boolean isSocialSecurityNumberEqual() {
        return this.getPerson().getSocialSecurityNumber().equals(this.getPersonalBean().getSocialSecurityNumber());
    }

    private static String readGivenName(String fullName, String familyName) {
        try {
            return fullName.substring(0, fullName.indexOf(familyName)).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new GivenNameMismatchException();
        }
    }

    public PersonBean getPersonBean() {
        PersonBean bean = new PersonBean();
        if (this.getPersonalBean().hasChosenPersonManually()) {
            bean.setPerson(this.getPersonalBean().getChosenPersonManually());
            return bean;
        }
        if (this.isPersonRegisteredOnFenix()) {
            bean.setPerson(this.getPerson());
            return bean;
        }
        PhdMigrationIndividualPersonalDataBean personalBean = this.getPersonalBean();
        bean.setAddress(personalBean.getAddress());
        bean.setArea(personalBean.getArea());
        bean.setAreaCode(personalBean.getAreaCode());
        bean.setParishOfResidence(personalBean.getParishOfResidence());
        bean.setDistrictOfResidence(personalBean.getDistrictOfResidence());
        bean.setDistrictSubdivisionOfResidence(personalBean.getDistrictSubdivisionOfResidence());
        bean.setPhone(personalBean.getContactNumber());
        bean.setWorkPhone(personalBean.getOtherContactNumber());
        bean.setProfession(personalBean.getProfession());
        bean.setEmail(personalBean.getEmail());
        bean.setFatherName(personalBean.getFatherName());
        bean.setMotherName(personalBean.getMotherName());
        bean.setIdDocumentType(IDDocumentType.OTHER);
        bean.setDocumentIdNumber(personalBean.getIdentificationNumber());
        bean.setSocialSecurityNumber(personalBean.getSocialSecurityNumber());
        bean.setGivenNames(PhdMigrationIndividualPersonalData.readGivenName(personalBean.getFullName(), personalBean.getFamilyName()));
        bean.setFamilyNames(personalBean.getFamilyName());
        bean.setDateOfBirth(new YearMonthDay(personalBean.getDateOfBirth().getYear(), personalBean.getDateOfBirth().getMonthOfYear(), personalBean.getDateOfBirth().getDayOfMonth()));
        bean.setGender(personalBean.getGender());
        bean.setNationality(personalBean.getNationality());
        return bean;
    }
}

