/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.debts.PhdThesisRequestFee_Base;

public class PhdThesisRequestFee
extends PhdThesisRequestFee_Base {
    private PhdThesisRequestFee() {
    }

    public PhdThesisRequestFee(PhdIndividualProgramProcess process2) {
        this();
        this.init(process2.getAdministrativeOffice(), process2.getPerson(), process2);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, PhdIndividualProgramProcess process2) {
        super.init(administrativeOffice, EventType.PHD_THESIS_REQUEST_FEE, person);
        this.checkProcess(process2);
        super.setProcess(process2);
    }

    private void checkProcess(PhdIndividualProgramProcess process2) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdThesisRequestFee.process.cannot.be.null", args);
        }
        if (process2.getThesisRequestFee() != null) {
            throw new DomainException("error.PhdThesisRequestFee.process.already.has.thesis.fee", new String[0]);
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    protected PhdProgram getPhdProgram() {
        return this.getProcess().getPhdProgram();
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.getProcess();
    }

    public boolean isPhdThesisRequestFee() {
        return true;
    }
}

