/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class GenderHelper {
    private static final Map<Locale, LabelValueBean[]> sexLabelValuesByLocale = new HashMap<Locale, LabelValueBean[]>(2);

    private GenderHelper() {
    }

    public static LabelValueBean[] getSexLabelValues(Locale locale) {
        LabelValueBean[] labelValueBeans;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((labelValueBeans = sexLabelValuesByLocale.get(locale)) != null) {
            return labelValueBeans;
        }
        labelValueBeans = new LabelValueBean[]{new LabelValueBean(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)locale, (String)Gender.MALE.name(), (String[])new String[0]), Gender.MALE.name()), new LabelValueBean(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)locale, (String)Gender.FEMALE.name(), (String[])new String[0]), Gender.FEMALE.name())};
        sexLabelValuesByLocale.put(locale, labelValueBeans);
        return labelValueBeans;
    }

    public static String toLocalizedString(Gender gender, Locale locale) {
        try {
            return BundleUtil.getString((String)"resources.ApplicationResources", (Locale)locale, (String)gender.name(), (String[])new String[0]);
        }
        catch (Exception swallowed) {
            return null;
        }
    }

    public static String toLocalizedString(Gender gender) {
        return GenderHelper.toLocalizedString(gender, Locale.getDefault());
    }

    public static Gender parseGender(String name) {
        for (Gender g : Gender.values()) {
            if (!g.name().equalsIgnoreCase(name)) continue;
            return g;
        }
        return null;
    }
}

