/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;

public class DegreeModulesSelectionLimit
extends DegreeModulesSelectionLimit_Base {
    private DegreeModulesSelectionLimit(Integer minimum, Integer maximum) {
        this.checkLimits(minimum, maximum);
        this.setMinimumLimit(minimum);
        this.setMaximumLimit(maximum);
        this.setCurricularRuleType(CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT);
    }

    public DegreeModulesSelectionLimit(CourseGroup degreeModuleToApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Integer minimum, Integer maximum) {
        this(minimum, maximum);
        this.init((DegreeModule)((Object)degreeModuleToApplyRule), contextCourseGroup, begin, end);
    }

    protected void edit(CourseGroup contextCourseGroup, Integer minimumLimit, Integer maximumLimit) {
        this.checkLimits(minimumLimit, maximumLimit);
        this.setContextCourseGroup(contextCourseGroup);
        this.setMinimumLimit(minimumLimit);
        this.setMaximumLimit(maximumLimit);
    }

    private void checkLimits(Integer minimum, Integer maximum) throws DomainException {
        if (minimum == null || maximum == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (minimum > maximum) {
            throw new DomainException("error.minimum.greater.than.maximum", new String[0]);
        }
    }

    public CourseGroup getDegreeModuleToApplyRule() {
        return (CourseGroup)((Object)super.getDegreeModuleToApplyRule());
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.modulesSelection", true));
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        if (this.getMinimumLimit().intValue() == this.getMaximumLimit().intValue()) {
            labelList.add(new GenericPair<String, Boolean>("label.choose", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getMinimumLimit(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            if (this.getMinimumLimit() == 1) {
                labelList.add(new GenericPair<String, Boolean>("label.module", true));
            } else {
                labelList.add(new GenericPair<String, Boolean>("label.modules", true));
            }
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.chooseFrom", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getMinimumLimit(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.to", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getMaximumLimit(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.modules", true));
        }
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inGroup", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    protected void removeOwnParameters() {
    }

    public boolean allowNumberOfDegreeModules(Integer value) {
        return value.compareTo(this.getMinimumLimit()) >= 0 && value.compareTo(this.getMaximumLimit()) <= 0;
    }

    public boolean numberOfDegreeModulesExceedMaximum(Integer numberOfDegreeModules) {
        return numberOfDegreeModules.compareTo(this.getMaximumLimit()) > 0;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

