/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.GenericPair;

public class AnyCurricularCourse
extends AnyCurricularCourse_Base {
    public AnyCurricularCourse(OptionalCurricularCourse toApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Double minimumCredits, Double maximumCredits, Integer curricularPeriodOrder, Integer minimumYear, Integer maximumYear, DegreeType degreeType, Degree degree, DepartmentUnit departmentUnit) {
        this.init((DegreeModule)((Object)toApplyRule), contextCourseGroup, begin, end, CurricularRuleType.ANY_CURRICULAR_COURSE);
        this.checkYears(minimumYear, maximumYear);
        this.setMinimumCredits(minimumCredits);
        this.setMaximumCredits(maximumCredits);
        this.setCurricularPeriodOrder(curricularPeriodOrder);
        this.setMinimumYear(minimumYear);
        this.setMaximumYear(maximumYear);
        this.setBolonhaDegreeType(degreeType);
        this.setDegree(degree);
        this.setDepartmentUnit(departmentUnit);
    }

    protected void edit(CourseGroup contextCourseGroup, Double credits, Integer curricularPeriodOrder, Integer minimumYear, Integer maximumYear, DegreeType degreeType, Degree degree, DepartmentUnit departmentUnit) {
        this.checkYears(minimumYear, maximumYear);
        this.setContextCourseGroup(contextCourseGroup);
        this.setCredits(credits);
        this.setCurricularPeriodOrder(curricularPeriodOrder);
        this.setMinimumYear(minimumYear);
        this.setMaximumYear(maximumYear);
        this.setBolonhaDegreeType(degreeType);
        this.setDegree(degree);
        this.setDepartmentUnit(departmentUnit);
    }

    private void checkYears(Integer minimumYear, Integer maximumYear) throws DomainException {
        if (minimumYear != null && maximumYear != null && minimumYear > maximumYear) {
            throw new DomainException("error.minimum.greater.than.maximum", new String[0]);
        }
    }

    public OptionalCurricularCourse getDegreeModuleToApplyRule() {
        return (OptionalCurricularCourse)((Object)super.getDegreeModuleToApplyRule());
    }

    public boolean appliesToContext(Context context) {
        return super.appliesToContext(context) && this.appliesToPeriod(context) && this.appliesToYears(context);
    }

    private boolean appliesToPeriod(Context context) {
        return !this.hasCurricularPeriodOrder() || this.hasCurricularPeriodOrderFor(context);
    }

    private boolean hasCurricularPeriodOrderFor(Context context) {
        return context != null && context.containsSemester(this.getCurricularPeriodOrder()) && context.getCurricularPeriod().getAcademicPeriod().equals((Object)AcademicPeriod.SEMESTER);
    }

    private boolean hasCurricularPeriodOrder() {
        return this.getCurricularPeriodOrder() != null && this.getCurricularPeriodOrder() != 0;
    }

    private boolean hasYearsLimit() {
        return this.getMinimumYear() != null && this.getMinimumYear() != 0 && this.getMaximumYear() != null && this.getMaximumYear() != 0;
    }

    private boolean appliesToYears(Context context) {
        if (!this.hasYearsLimit()) {
            return true;
        }
        if (this.hasCurricularPeriodOrder()) {
            for (int year = this.getMinimumYear().intValue(); year <= this.getMaximumYear(); ++year) {
                if (!context.containsSemesterAndCurricularYear(this.getCurricularPeriodOrder(), year, RegimeType.SEMESTRIAL)) continue;
                return true;
            }
        } else {
            for (int year = this.getMinimumYear().intValue(); year <= this.getMaximumYear(); ++year) {
                if (!context.containsSemesterAndCurricularYear(1, year, RegimeType.SEMESTRIAL) && !context.containsSemesterAndCurricularYear(2, year, RegimeType.SEMESTRIAL)) continue;
                return true;
            }
        }
        return false;
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.anyCurricularCourse", true));
        if (this.getMinimumCredits() != null && this.getMaximumCredits() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            if (this.getMinimumCredits().doubleValue() == this.getMaximumCredits().doubleValue()) {
                labelList.add(new GenericPair<String, Boolean>("label.with", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
            } else {
                labelList.add(new GenericPair<String, Boolean>("label.with.minimum", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<String, Boolean>("label.to", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<Double, Boolean>(this.getMaximumCredits(), false));
            }
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.credits", true));
        }
        if (this.getMinimumCredits() == null && this.getMaximumCredits() != null || this.getMinimumCredits() != null && this.getMaximumCredits() == null) {
            labelList.add(new GenericPair<String, Boolean>("label.with", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.credits", true));
        }
        if (this.getCurricularPeriodOrder() != 0) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.in", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getCurricularPeriodOrder(), false));
            labelList.add(new GenericPair<String, Boolean>("\u00ba ", false));
            labelList.add(new GenericPair<String, Boolean>("SEMESTER", true));
        }
        if (this.hasYearsLimit()) {
            if (this.getMinimumYear().compareTo(this.getMaximumYear()) == 0) {
                labelList.add(new GenericPair<String, Boolean>(", ", false));
                labelList.add(new GenericPair<String, Boolean>("label.of", true));
                labelList.add(new GenericPair<String, Boolean>("\u00ba ", false));
                labelList.add(new GenericPair<Integer, Boolean>(this.getMinimumYear(), false));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<String, Boolean>("label.year", true));
            } else {
                labelList.add(new GenericPair<String, Boolean>(", ", false));
                labelList.add(new GenericPair<String, Boolean>("label.of", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<Integer, Boolean>(this.getMinimumYear(), false));
                labelList.add(new GenericPair<String, Boolean>("\u00ba ", false));
                labelList.add(new GenericPair<String, Boolean>("label.to1", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<Integer, Boolean>(this.getMaximumYear(), false));
                labelList.add(new GenericPair<String, Boolean>("\u00ba ", false));
                labelList.add(new GenericPair<String, Boolean>("label.year", true));
            }
        }
        labelList.add(new GenericPair<String, Boolean>(", ", false));
        if (this.getDegree() == null) {
            if (!this.hasBolonhaDegreeType()) {
                labelList.add(new GenericPair<String, Boolean>("label.of", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<String, Boolean>(Unit.getInstitutionAcronym(), false));
            } else {
                labelList.add(new GenericPair<String, Boolean>("label.of1", true));
                labelList.add(new GenericPair<String, Boolean>(" ", false));
                labelList.add(new GenericPair<String, Boolean>(this.getBolonhaDegreeType().getName().getContent(), false));
            }
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.of", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.degree", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getDegree().getNome(), false));
        }
        if (this.getDepartmentUnit() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.of", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getDepartmentUnit().getName(), false));
        }
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inGroup", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    protected void removeOwnParameters() {
        this.setDegree(null);
        this.setDepartmentUnit(null);
        this.setBolonhaDegreeType(null);
    }

    public boolean hasBolonhaDegreeType() {
        return this.getBolonhaDegreeType() != null;
    }

    public boolean hasCredits() {
        return this.getCredits() != null && this.getCredits() != 0.0;
    }

    public boolean hasMinimumCredits() {
        return this.getMinimumCredits() != null && this.getMinimumCredits() != 0.0;
    }

    public boolean hasMaximumCredits() {
        return this.getMaximumCredits() != null && this.getMaximumCredits() != 0.0;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

