/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.List;
import org.fenixedu.academic.domain.curricularRules.AndRule_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.GenericPair;

public class AndRule
extends AndRule_Base {
    public AndRule(CurricularRule ... curricularRules) {
        this.initCompositeRule(curricularRules);
        this.setCompositeRuleType(LogicOperator.AND);
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        return this.getLabel("label.operator.and");
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            result = result.and(curricularRule.evaluate(sourceDegreeModuleToEvaluate, enrolmentContext));
        }
        return result;
    }

    public RuleResult verify(VerifyRuleLevel verifyRuleLevel, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
        RuleResult result = RuleResult.createTrue(degreeModuleToVerify);
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            result = result.and(curricularRule.verify(verifyRuleLevel, enrolmentContext, degreeModuleToVerify, parentCourseGroup));
        }
        return result;
    }
}

