/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.over23;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.events.candidacy.Over23IndividualCandidacyEvent;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.Formation;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyDegreeEntry;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacy_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class Over23IndividualCandidacy
extends Over23IndividualCandidacy_Base {
    private Over23IndividualCandidacy() {
    }

    Over23IndividualCandidacy(Over23IndividualCandidacyProcess process2, Over23IndividualCandidacyProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        this.setDisabilities(bean.getDisabilities());
        this.setEducation(bean.getEducation());
        this.setLanguages(bean.getLanguages());
        this.setLanguagesRead(bean.getLanguagesRead());
        this.setLanguagesWrite(bean.getLanguagesWrite());
        this.setLanguagesSpeak(bean.getLanguagesSpeak());
        this.createDegreeEntries(bean.getSelectedDegrees());
        this.createFormationEntries(bean.getFormationConcludedBeanList(), bean.getFormationNonConcludedBeanList());
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            this.createDebt(person);
        }
    }

    protected void createFormationEntries(List<FormationBean> formationConcludedBeanList, List<FormationBean> formationNonConcludedBeanList) {
        for (FormationBean formation : formationConcludedBeanList) {
            this.addFormations(new Formation((IndividualCandidacy)((Object)this), formation));
        }
        for (FormationBean formation : formationNonConcludedBeanList) {
            this.addFormations(new Formation((IndividualCandidacy)((Object)this), formation));
        }
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        Over23IndividualCandidacyProcess over23Process = (Over23IndividualCandidacyProcess)((Object)process2);
        Over23IndividualCandidacyProcessBean over23ProcessBean = (Over23IndividualCandidacyProcessBean)bean;
        LocalDate candidacyDate = bean.getCandidacyDate();
        List<Degree> degrees = over23ProcessBean.getSelectedDegrees();
        this.checkParameters(person, over23Process, candidacyDate, degrees);
    }

    private void checkParameters(Person person, Over23IndividualCandidacyProcess process2, LocalDate candidacyDate, List<Degree> degrees) {
        this.checkParameters(person, (IndividualCandidacyProcess)((Object)process2), candidacyDate);
    }

    private void checkDegrees(List<Degree> degrees) {
        if (degrees == null || degrees.isEmpty()) {
            throw new DomainException("error.Over23IndividualCandidacy.invalid.degrees", new String[0]);
        }
    }

    private void createDegreeEntries(List<Degree> degrees) {
        for (int index = 0; index < degrees.size(); ++index) {
            new Over23IndividualCandidacyDegreeEntry(this, degrees.get(index), index + 1);
        }
    }

    private void removeExistingDegreeEntries() {
        while (!this.getOver23IndividualCandidacyDegreeEntriesSet().isEmpty()) {
            ((Over23IndividualCandidacyDegreeEntry)((Object)this.getOver23IndividualCandidacyDegreeEntriesSet().iterator().next())).delete();
        }
    }

    protected void createDebt(Person person) {
        new Over23IndividualCandidacyEvent(this, person);
    }

    void saveChoosedDegrees(List<Degree> degrees) {
        if (!degrees.isEmpty()) {
            this.removeExistingDegreeEntries();
            this.createDegreeEntries(degrees);
        }
    }

    public Over23IndividualCandidacyProcess getCandidacyProcess() {
        return (Over23IndividualCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    void editCandidacyInformation(LocalDate candidacyDate, List<Degree> degrees, String disabilities, String education, String languagesRead, String languagesWrite, String languagesSpeak) {
        this.checkParameters(this.getPersonalDetails().getPerson(), (IndividualCandidacyProcess)((Object)this.getCandidacyProcess()), candidacyDate);
        this.checkDegrees(degrees);
        this.setCandidacyDate(candidacyDate);
        this.saveChoosedDegrees(degrees);
        this.setDisabilities(disabilities);
        this.setEducation(education);
        this.setLanguagesRead(languagesRead);
        this.setLanguagesSpeak(languagesSpeak);
        this.setLanguagesWrite(languagesWrite);
    }

    List<Degree> getSelectedDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>(this.getOver23IndividualCandidacyDegreeEntriesSet().size());
        for (Over23IndividualCandidacyDegreeEntry entry : this.getOver23IndividualCandidacyDegreeEntriesSet()) {
            result.add(entry.getDegree());
        }
        return result;
    }

    List<Degree> getSelectedDegreesSortedByOrder() {
        TreeSet<Over23IndividualCandidacyDegreeEntry> entries = new TreeSet<Over23IndividualCandidacyDegreeEntry>(Over23IndividualCandidacyDegreeEntry.COMPARATOR_BY_ORDER);
        entries.addAll(this.getOver23IndividualCandidacyDegreeEntriesSet());
        ArrayList<Degree> result = new ArrayList<Degree>(entries.size());
        for (Over23IndividualCandidacyDegreeEntry entry : entries) {
            result.add(entry.getDegree());
        }
        return result;
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.addAll(this.getSelectedDegrees());
        return result;
    }

    void editCandidacyResult(IndividualCandidacyState state, Degree acceptedDegree) {
        this.checkParameters(state, acceptedDegree);
        this.setAcceptedDegree(acceptedDegree);
        if (this.isCandidacyResultStateValid(state)) {
            this.setState(state);
        }
    }

    private void checkParameters(IndividualCandidacyState state, Degree acceptedDegree) {
        if (state != null) {
            if (!(state != IndividualCandidacyState.ACCEPTED || acceptedDegree != null && this.getSelectedDegrees().contains(acceptedDegree))) {
                throw new DomainException("error.Over23IndividualCandidacy.invalid.acceptedDegree", new String[0]);
            }
            if (this.isAccepted() && state != IndividualCandidacyState.ACCEPTED && this.getRegistration() != null) {
                throw new DomainException("error.Over23IndividualCandidacy.cannot.change.state.from.accepted.candidacies", new String[0]);
            }
        }
    }

    protected ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = super.createRegistration(person, degreeCurricularPlan, cycleType, ingressionType);
        registration.setRegistrationYear(this.getCandidacyExecutionInterval());
        return registration;
    }

    public void exportValues(StringBuilder result) {
        super.exportValues(result);
        Formatter formatter = new Formatter(result);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.over23.languages.read", (String[])new String[0]), StringUtils.isEmpty((String)this.getLanguagesRead()) ? "" : this.getLanguagesRead());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.over23.languages.write", (String[])new String[0]), StringUtils.isEmpty((String)this.getLanguagesWrite()) ? "" : this.getLanguagesWrite());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.over23.languages.speak", (String[])new String[0]), StringUtils.isEmpty((String)this.getLanguagesSpeak()) ? "" : this.getLanguagesSpeak());
        formatter.close();
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + (this.getAcceptedDegree() != null ? ": " + this.getAcceptedDegree().getNameI18N() : "");
    }

    public boolean isOver23() {
        return true;
    }
}

