/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import org.fenixedu.academic.domain.candidacy.CandidacyDocumentFile_Base;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.servlets.FileDownloadServlet;

public class CandidacyDocumentFile
extends CandidacyDocumentFile_Base {
    public CandidacyDocumentFile(String filename, String displayName, byte[] content) {
        this.init(displayName, filename, content);
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    public boolean isAccessible(User user) {
        if (RoleType.MASTER_DEGREE_ADMINISTRATIVE_OFFICE.isMember(user)) {
            return true;
        }
        if (RoleType.COORDINATOR.isMember(user)) {
            return true;
        }
        User candidate = this.getCandidacyDocument().getCandidacy().getPerson().getUser();
        return candidate != null && candidate.equals((Object)user);
    }

    @Deprecated
    public String getDownloadUrl() {
        return FileDownloadServlet.getDownloadUrl((GenericFile)this);
    }

    public void delete() {
        this.setCandidacyDocument(null);
        super.delete();
    }
}

