/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report;

import java.util.Collection;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.report.GratuityReport;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class GratuityReportingService {
    public GratuityReport createGratuityReport(ExecutionYear executionYear, LocalDate startDate, LocalDate endDate, Collection<DegreeType> degreeTypes) {
        AccessControl.check(this, RolePredicates.DIRECTIVE_COUNCIL_PREDICATE);
        GratuityReport report = new GratuityReport();
        for (AnnualEvent event : executionYear.getAnnualEventsSet()) {
            if (!(event instanceof GratuityEvent)) continue;
            GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
            if (!degreeTypes.isEmpty() && !degreeTypes.contains(gratuityEvent.getDegree().getDegreeType())) continue;
            for (AccountingTransaction transaction : event.getNonAdjustingTransactions()) {
                if (startDate != null && endDate != null) {
                    if (!transaction.isInsidePeriod(startDate, endDate)) continue;
                    report.addGratuityAmount(transaction.getWhenRegistered().toLocalDate(), transaction.getAmountWithAdjustment());
                    continue;
                }
                if (startDate != null) {
                    if (transaction.getWhenRegistered().toLocalDate().isBefore((ReadablePartial)startDate)) continue;
                    report.addGratuityAmount(transaction.getWhenRegistered().toLocalDate(), transaction.getAmountWithAdjustment());
                    continue;
                }
                if (endDate != null) {
                    if (transaction.getWhenRegistered().toLocalDate().isAfter((ReadablePartial)endDate)) continue;
                    report.addGratuityAmount(transaction.getWhenRegistered().toLocalDate(), transaction.getAmountWithAdjustment());
                    continue;
                }
                report.addGratuityAmount(transaction.getWhenRegistered().toLocalDate(), transaction.getAmountWithAdjustment());
            }
        }
        return report;
    }
}

