/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.candidacy;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountPR;
import org.fenixedu.academic.domain.accounting.postingRules.candidacy.StandaloneIndividualCandidacyPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class StandaloneIndividualCandidacyPR
extends StandaloneIndividualCandidacyPR_Base {
    protected StandaloneIndividualCandidacyPR() {
    }

    public StandaloneIndividualCandidacyPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.STANDALONE_INDIVIDUAL_CANDIDACY_FEE, EventType.STANDALONE_INDIVIDUAL_CANDIDACY, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (event.getExemptionsSet().isEmpty()) {
            return amountToPay;
        }
        for (Exemption exemption : event.getExemptionsSet()) {
            if (!exemption.isAcademicEventExemption()) continue;
            AcademicEventExemption academicEventExemption = (AcademicEventExemption)((Object)exemption);
            amountToPay = amountToPay.subtract(academicEventExemption.getValue());
        }
        if (amountToPay.isNegative()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    public FixedAmountPR edit(Money fixedAmount) {
        this.deactivate();
        return new FixedAmountPR(this.getEntryType(), this.getEventType(), new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }
}

