/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.DuplicateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.DuplicateRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.DuplicateRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class DuplicateRequestPR
extends DuplicateRequestPR_Base {
    protected DuplicateRequestPR() {
    }

    public DuplicateRequestPR(DateTime startDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this();
        this.init(EntryType.DUPLICATE_REQUEST_FEE, EventType.DUPLICATE_REQUEST, startDate, null, serviceAgreementTemplate);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        RegistrationAcademicServiceRequest academicServiceRequest = ((DuplicateRequestEvent)((Object)event)).getAcademicServiceRequest();
        return ((DuplicateRequest)((Object)academicServiceRequest)).getAmountToPay();
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(event, when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, totalAmountToPay, Money.ZERO, totalAmountToPay, event.getDescriptionForEntryType(this.getEntryType()), totalAmountToPay));
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.DuplicateRequestPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }
}

