/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode$callable$createPaymentCodes;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class IndividualCandidacyPaymentCode
extends IndividualCandidacyPaymentCode_Base {
    public static final Advice advice$createPaymentCodes = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected IndividualCandidacyPaymentCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        this.init(paymentCodeType, startDate, endDate, minAmount, maxAmount);
    }

    public static IndividualCandidacyPaymentCode create(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        return PaymentCode.canGenerateNewCode(IndividualCandidacyPaymentCode.class, paymentCodeType, null) ? new IndividualCandidacyPaymentCode(paymentCodeType, startDate, endDate, minAmount, maxAmount) : IndividualCandidacyPaymentCode.findAndReuseExistingCode(paymentCodeType, startDate, endDate, minAmount, maxAmount);
    }

    public static IndividualCandidacyPaymentCode getAvailablePaymentCodeAndUse(PaymentCodeType paymentCodeType, YearMonthDay date, Event event, Person person) {
        Set individualCandidacyPaymentCodes = Bennu.getInstance().getPaymentCodesSet();
        for (PaymentCode paymentCode : individualCandidacyPaymentCodes) {
            IndividualCandidacyPaymentCode individualCandidacyPaymentCode;
            if (!(paymentCode instanceof IndividualCandidacyPaymentCode) || !(individualCandidacyPaymentCode = (IndividualCandidacyPaymentCode)((Object)paymentCode)).isAvailable(paymentCodeType, date).booleanValue()) continue;
            individualCandidacyPaymentCode.use(event, person);
            return individualCandidacyPaymentCode;
        }
        return null;
    }

    public static List<IndividualCandidacyPaymentCode> getAvailablePaymentCodes(PaymentCodeType paymentCodeType, YearMonthDay date) {
        ArrayList<IndividualCandidacyPaymentCode> result = new ArrayList<IndividualCandidacyPaymentCode>();
        Set individualCandidacyPaymentCodes = Bennu.getInstance().getPaymentCodesSet();
        for (PaymentCode paymentCode : individualCandidacyPaymentCodes) {
            IndividualCandidacyPaymentCode individualCandidacyPaymentCode;
            if (!(paymentCode instanceof IndividualCandidacyPaymentCode) || !(individualCandidacyPaymentCode = (IndividualCandidacyPaymentCode)((Object)paymentCode)).isAvailable(paymentCodeType, date).booleanValue()) continue;
            result.add(individualCandidacyPaymentCode);
        }
        return result;
    }

    protected void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        super.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, null);
    }

    protected Boolean isAvailable(PaymentCodeType paymentCodeType, YearMonthDay date) {
        return this.getType().equals((Object)paymentCodeType) && !this.getStartDate().isAfter((ReadablePartial)date) && !this.getEndDate().isBefore((ReadablePartial)date) && this.getPerson() == null;
    }

    protected static IndividualCandidacyPaymentCode findAndReuseExistingCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        IndividualCandidacyPaymentCode paymentCode = IndividualCandidacyPaymentCode.getAvailablePaymentCodeForReuse();
        paymentCode.reuse(startDate, endDate, minAmount, maxAmount, null);
        return paymentCode;
    }

    protected static IndividualCandidacyPaymentCode getAvailablePaymentCodeForReuse() {
        HashSet individualCandidacyPaymentCodes = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getPaymentCodesSet(), IndividualCandidacyPaymentCode.class));
        for (IndividualCandidacyPaymentCode paymentCode : individualCandidacyPaymentCodes) {
            if (!paymentCode.isAvailableForReuse()) continue;
            return paymentCode;
        }
        return null;
    }

    protected void checkParameters(Event event, Person person) {
        if (event == null) {
            throw new DomainException("error.accounting.paymentCodes.IndividualCandidacyPaymentCode.event.cannot.be.null", new String[0]);
        }
        if (person == null) {
            throw new DomainException("error.accounting.paymentCodes.IndividualCandidacyPaymentCode.person.cannot.be.null", new String[0]);
        }
    }

    protected void use(Event event, Person person) {
        this.checkParameters(event, person);
        this.setPerson(person);
        this.setAccountingEvent(event);
    }

    public void setPerson(Person student) {
        if (this.getPerson() != null || !this.isNew()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.person", new String[0]);
        }
        super._setPerson(student);
    }

    public static List<IndividualCandidacyPaymentCode> createPaymentCodes(PaymentCodeType paymentCodeType, LocalDate localDate, LocalDate localDate2, Money money, Money money2, Integer n) {
        return (List)advice$createPaymentCodes.perform((Callable)new IndividualCandidacyPaymentCode$callable$createPaymentCodes(paymentCodeType, localDate, localDate2, money, money2, n));
    }

    static /* synthetic */ List<IndividualCandidacyPaymentCode> advised$createPaymentCodes(PaymentCodeType type, LocalDate beginDate, LocalDate endDate, Money minimum, Money maximum, Integer numberOfPaymentCodes) {
        ArrayList<IndividualCandidacyPaymentCode> result = new ArrayList<IndividualCandidacyPaymentCode>();
        for (int i = 0; i < numberOfPaymentCodes; ++i) {
            result.add(IndividualCandidacyPaymentCode.create(type, beginDate.toDateTimeAtStartOfDay().toYearMonthDay(), endDate.toDateTimeAtStartOfDay().toYearMonthDay(), minimum, maximum));
        }
        return result;
    }
}

