/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class SearchDegreeStudentsGroup
implements Serializable {
    private static final long serialVersionUID = -1670838875686375271L;
    private DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionYear executionYear;
    private String sortBy = null;
    private RegistrationStateType registrationStateType;
    private Double minGrade;
    private Double maxGrade;
    private Double minNumberApproved;
    private Double maxNumberApproved;
    private Double minStudentNumber;
    private Double maxStudentNumber;
    private Integer minimumYear;
    private Integer maximumYear;

    public SearchDegreeStudentsGroup(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, String sortBy, RegistrationStateType registrationStateType, Double minGrade, Double maxGrade, Double minNumberApproved, Double maxNumberApproved, Double minStudentNumber, Double maxStudentNumber, Integer minimumYear, Integer maximumYear) {
        this.degreeCurricularPlan = degreeCurricularPlan;
        this.executionYear = executionYear;
        this.sortBy = sortBy;
        this.registrationStateType = registrationStateType;
        this.minGrade = minGrade;
        this.maxGrade = maxGrade;
        this.minNumberApproved = minNumberApproved;
        this.maxNumberApproved = maxNumberApproved;
        this.minStudentNumber = minStudentNumber;
        this.maxStudentNumber = maxStudentNumber;
        this.minimumYear = minimumYear;
        this.maximumYear = maximumYear;
    }

    public RegistrationStateType getRegistrationStateType() {
        return this.registrationStateType;
    }

    public void setRegistrationStateType(RegistrationStateType state) {
        this.registrationStateType = state;
    }

    public Double getMinGrade() {
        return this.minGrade;
    }

    public String getMinGradeString() {
        return this.minGrade != null ? String.valueOf(this.minGrade) : "ND";
    }

    public void setMinGrade(Double minGrade) {
        this.minGrade = minGrade;
    }

    public Double getMaxGrade() {
        return this.maxGrade;
    }

    public String getMaxGradeString() {
        return this.maxGrade != null ? String.valueOf(this.maxGrade) : "ND";
    }

    public void setMaxGrade(Double maxGrade) {
        this.maxGrade = maxGrade;
    }

    public Double getMinNumberApproved() {
        return this.minNumberApproved;
    }

    public String getMinNumberApprovedString() {
        return this.minNumberApproved != null ? String.valueOf(this.minNumberApproved) : "ND";
    }

    public void setMinNumberApproved(Double minNumberApproved) {
        this.minNumberApproved = minNumberApproved;
    }

    public Double getMaxNumberApproved() {
        return this.maxNumberApproved;
    }

    public String getMaxNumberApprovedString() {
        return this.maxNumberApproved != null ? String.valueOf(this.maxNumberApproved) : "ND";
    }

    public void setMaxNumberApproved(Double maxNumberApproved) {
        this.maxNumberApproved = maxNumberApproved;
    }

    public Double getMinStudentNumber() {
        return this.minStudentNumber;
    }

    public String getMinStudentNumberString() {
        return this.minStudentNumber != null ? String.valueOf(this.minStudentNumber) : "ND";
    }

    public void setMinStudentNumber(Double minStudentNumber) {
        this.minStudentNumber = minStudentNumber;
    }

    public Double getMaxStudentNumber() {
        return this.maxStudentNumber;
    }

    public String getMaxStudentNumberString() {
        return this.maxStudentNumber != null ? String.valueOf(this.maxStudentNumber) : "ND";
    }

    public void setMaxStudentNumber(Double maxStudentNumber) {
        this.maxStudentNumber = maxStudentNumber;
    }

    public Integer getMinimumYear() {
        return this.minimumYear;
    }

    public String getMinimumYearString() {
        return this.minimumYear != null ? String.valueOf(this.minimumYear) : "ND";
    }

    public void setMinimumYear(Integer minimumYear) {
        this.minimumYear = minimumYear;
    }

    public Integer getMaximumYear() {
        return this.maximumYear;
    }

    public String getMaximumYearString() {
        return this.maximumYear != null ? String.valueOf(this.maximumYear) : "ND";
    }

    public void setMaximumYear(Integer maximumYear) {
        this.maximumYear = maximumYear;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degree) {
        this.degreeCurricularPlan = degree;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public String getSortBy() {
        return this.sortBy != null ? this.sortBy : "student.number";
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public Set<Person> getElements() {
        HashSet<Person> elements = new HashSet<Person>();
        Map<StudentCurricularPlan, RegistrationStateType> students = this.searchStudentCurricularPlans(null, null);
        for (StudentCurricularPlan student : students.keySet()) {
            elements.add(student.getPerson());
        }
        return elements;
    }

    public Group getUserGroup() {
        HashSet<User> users = new HashSet<User>();
        Map<StudentCurricularPlan, RegistrationStateType> students = this.searchStudentCurricularPlans(null, null);
        for (StudentCurricularPlan student : students.keySet()) {
            User user = student.getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return UserGroup.of(users);
    }

    private Comparator<StudentCurricularPlan> determineComparatorKind() {
        String sortBy = this.getSortBy() != null && !this.getSortBy().equalsIgnoreCase("null") ? this.getSortBy() : "student.number";
        if (sortBy.equals("registration.average")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    if (this.isConcludedAndRegistrationConclusionProcessed(left.getRegistration()) && this.isConcludedAndRegistrationConclusionProcessed(right.getRegistration())) {
                        return left.getRegistration().getRawGrade().compareTo(right.getRegistration().getRawGrade());
                    }
                    if (this.isConcludedAndRegistrationConclusionProcessed(left.getRegistration())) {
                        return 1;
                    }
                    if (this.isConcludedAndRegistrationConclusionProcessed(right.getRegistration())) {
                        return -1;
                    }
                    if (left.getRegistration().isConcluded() && right.getRegistration().isConcluded()) {
                        return left.getExternalId().compareTo(right.getExternalId());
                    }
                    if (left.getRegistration().isConcluded()) {
                        return -1;
                    }
                    if (right.getRegistration().isConcluded()) {
                        return 1;
                    }
                    int result = left.getRegistration().getRawGrade().compareTo(right.getRegistration().getRawGrade());
                    return result == 0 ? left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber()) : result;
                }

                private boolean isConcludedAndRegistrationConclusionProcessed(Registration registration) {
                    return registration.isConcluded() && registration.isRegistrationConclusionProcessed();
                }
            };
        }
        if (sortBy.equals("currentState")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    int result = left.getRegistration().getLastRegistrationState(SearchDegreeStudentsGroup.this.getExecutionYear()).getStateType().getDescription().compareTo(right.getRegistration().getLastRegistrationState(SearchDegreeStudentsGroup.this.getExecutionYear()).getStateType().getDescription());
                    return result == 0 ? left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber()) : result;
                }
            };
        }
        if (sortBy.equals("registration.person.name")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    int result = left.getRegistration().getPerson().getName().compareTo(right.getRegistration().getPerson().getName());
                    return result == 0 ? left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber()) : result;
                }
            };
        }
        if (sortBy.equals("student.number")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                }
            };
        }
        if (sortBy.equals("registration.person.email")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    if (left.getRegistration().getPerson().getDefaultEmailAddress() == null && right.getRegistration().getPerson().getDefaultEmailAddress() == null) {
                        return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                    }
                    if (left.getRegistration().getPerson().getDefaultEmailAddress() == null) {
                        return -1;
                    }
                    if (right.getRegistration().getPerson().getDefaultEmailAddress() == null) {
                        return 1;
                    }
                    int result = EmailAddress.COMPARATOR_BY_EMAIL.compare(left.getRegistration().getPerson().getDefaultEmailAddress(), right.getRegistration().getPerson().getDefaultEmailAddress());
                    if (result > 0) {
                        return 1;
                    }
                    if (result < 0) {
                        return -1;
                    }
                    return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                }
            };
        }
        if (sortBy.equals("registration.numberOfCurriculumEntries")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    if (left.getRegistration().getNumberOfCurriculumEntries() > right.getRegistration().getNumberOfCurriculumEntries()) {
                        return 1;
                    }
                    if (left.getRegistration().getNumberOfCurriculumEntries() < right.getRegistration().getNumberOfCurriculumEntries()) {
                        return -1;
                    }
                    return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                }
            };
        }
        if (sortBy.equals("registration.ectsCredits")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    if (left.getRegistration().getEctsCredits() > right.getRegistration().getEctsCredits()) {
                        return 1;
                    }
                    if (left.getRegistration().getEctsCredits() < right.getRegistration().getEctsCredits()) {
                        return -1;
                    }
                    return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                }
            };
        }
        if (sortBy.equals("registration.curricularYear")) {
            return new Comparator<StudentCurricularPlan>(){

                @Override
                public int compare(StudentCurricularPlan left, StudentCurricularPlan right) {
                    if (left.getRegistration().getCurricularYear() > right.getRegistration().getCurricularYear()) {
                        return 1;
                    }
                    if (left.getRegistration().getCurricularYear() < right.getRegistration().getCurricularYear()) {
                        return -1;
                    }
                    return left.getRegistration().getStudent().getNumber().compareTo(right.getRegistration().getStudent().getNumber());
                }
            };
        }
        return null;
    }

    public Map<StudentCurricularPlan, RegistrationStateType> searchStudentCurricularPlans(Integer minIndex, Integer maxIndex) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        ArrayList<StudentCurricularPlan> studentCurricularPlans = new ArrayList<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
            if (!this.matchesSelectCriteria(studentCurricularPlan)) continue;
            studentCurricularPlans.add(studentCurricularPlan);
        }
        Comparator<StudentCurricularPlan> comparator = this.determineComparatorKind();
        TreeMap<StudentCurricularPlan, RegistrationStateType> map = new TreeMap<StudentCurricularPlan, RegistrationStateType>(comparator);
        if (minIndex != null || maxIndex != null) {
            for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans.subList(minIndex - 1, Math.min(maxIndex, studentCurricularPlans.size()))) {
                map.put(studentCurricularPlan, null);
            }
        } else {
            for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans) {
                map.put(studentCurricularPlan, null);
            }
        }
        return map;
    }

    public boolean matchesSelectCriteria(StudentCurricularPlan studentCurricularPlan) {
        if (!studentCurricularPlan.hasRegistration() || studentCurricularPlan.getRegistration().isTransition()) {
            return false;
        }
        if (this.registrationStateType == null) {
            return true;
        }
        RegistrationState lastRegistrationState = studentCurricularPlan.getRegistration().getLastRegistrationState(this.executionYear);
        if (lastRegistrationState == null || lastRegistrationState.getStateType() != this.registrationStateType) {
            return false;
        }
        double arithmeticMean = studentCurricularPlan.getRegistration().getCurriculum().getRawGrade().getNumericValue().doubleValue();
        if (this.minGrade != null && this.minGrade > arithmeticMean) {
            return false;
        }
        if (this.maxGrade != null && this.maxGrade < arithmeticMean) {
            return false;
        }
        int approvedEnrollmentsNumber = studentCurricularPlan.getRegistration().getNumberOfCurriculumEntries();
        if (this.minNumberApproved != null && this.minNumberApproved > (double)approvedEnrollmentsNumber) {
            return false;
        }
        if (this.maxNumberApproved != null && this.maxNumberApproved < (double)approvedEnrollmentsNumber) {
            return false;
        }
        int studentNumber = studentCurricularPlan.getRegistration().getNumber();
        if (this.minStudentNumber != null && this.minStudentNumber > (double)studentNumber) {
            return false;
        }
        if (this.maxStudentNumber != null && this.maxStudentNumber < (double)studentNumber) {
            return false;
        }
        int curricularYear = studentCurricularPlan.getRegistration().getCurricularYear();
        if (this.minimumYear != null && this.minimumYear > curricularYear) {
            return false;
        }
        return this.maximumYear == null || this.maximumYear >= curricularYear;
    }

    public String getApplicationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)name, (String[])new String[0]);
    }

    public String getLabel() {
        String label = new String();
        label = String.format("%s : %s \n%s : %s \n%s : %s \n%s : %s \n%s : %s", this.getApplicationResourcesString("label.selectStudents"), this.getRegistrationStateType().getDescription(), this.getApplicationResourcesString("label.student.number"), this.getMinStudentNumberString() + " - " + this.getMaxStudentNumberString(), this.getApplicationResourcesString("label.average"), this.getMinGradeString() + " - " + this.getMaxGradeString(), this.getApplicationResourcesString("label.number.approved.curricular.courses"), this.getMinNumberApprovedString() + " - " + this.getMaxNumberApprovedString(), this.getApplicationResourcesString("label.student.curricular.year"), this.getMinimumYearString() + " - " + this.getMaximumYearString());
        return label;
    }

    public static SearchDegreeStudentsGroup parse(String serialized) {
        String[] parts = serialized.split(":");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)parts[0]);
        ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)parts[1]);
        String sortBy = parts[2];
        RegistrationStateType registrationStateType = parts[3].equals("ND") ? null : RegistrationStateType.valueOf(parts[3]);
        Double minGrade = parts[4].equals("ND") ? null : Double.valueOf(parts[4]);
        Double maxGrade = parts[5].equals("ND") ? null : Double.valueOf(parts[5]);
        Double minNumberApproved = parts[6].equals("ND") ? null : Double.valueOf(parts[6]);
        Double maxNumberApproved = parts[7].equals("ND") ? null : Double.valueOf(parts[7]);
        Double minStudentNumber = parts[8].equals("ND") ? null : Double.valueOf(parts[8]);
        Double maxStudentNumber = parts[9].equals("ND") ? null : Double.valueOf(parts[9]);
        Integer minimumYear = parts[10].equals("ND") ? null : Integer.valueOf(parts[10]);
        Integer maximumYear = parts[11].equals("ND") ? null : Integer.valueOf(parts[11]);
        return new SearchDegreeStudentsGroup(degreeCurricularPlan, executionYear, sortBy, registrationStateType, minGrade, maxGrade, minNumberApproved, maxNumberApproved, minStudentNumber, maxStudentNumber, minimumYear, maximumYear);
    }

    public String serialize() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getDegreeCurricularPlan().getExternalId());
        parts.add(this.getExecutionYear().getExternalId());
        parts.add(this.getSortBy());
        parts.add(this.getRegistrationStateType() != null ? this.getRegistrationStateType().getName() : "ND");
        parts.add(this.getMinGradeString());
        parts.add(this.getMaxGradeString());
        parts.add(this.getMinNumberApprovedString());
        parts.add(this.getMaxNumberApprovedString());
        parts.add(this.getMinStudentNumberString());
        parts.add(this.getMaxStudentNumberString());
        parts.add(this.getMinimumYearString());
        parts.add(this.getMaximumYearString());
        return Joiner.on((char)':').join(parts);
    }
}

