/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.CoordinatorGroup;
import org.fenixedu.academic.domain.accessControl.PersistentCoordinatorGroup_Base;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.core.groups.Group;

public class PersistentCoordinatorGroup
extends PersistentCoordinatorGroup_Base {
    protected PersistentCoordinatorGroup(DegreeType degreeType, Degree degree) {
        this.setDegreeType(degreeType);
        this.setDegree(degree);
        if (degree != null) {
            this.setRootForFenixPredicate(null);
        }
    }

    public Group toGroup() {
        return CoordinatorGroup.get(this.getDegreeType(), this.getDegree());
    }

    protected void gc() {
        this.setDegree(null);
        super.gc();
    }

    public static PersistentCoordinatorGroup getInstance() {
        return PersistentCoordinatorGroup.getInstance(null, null);
    }

    public static PersistentCoordinatorGroup getInstance(DegreeType degreeType, Degree degree) {
        return (PersistentCoordinatorGroup)PersistentCoordinatorGroup.singleton(() -> PersistentCoordinatorGroup.select(degreeType, degree), () -> new PersistentCoordinatorGroup(degreeType, degree));
    }

    private static Optional<PersistentCoordinatorGroup> select(DegreeType degreeType, Degree degree) {
        Stream stream = degree != null ? degree.getCoordinatorGroupSet().stream() : PersistentCoordinatorGroup.filter(PersistentCoordinatorGroup.class);
        return stream.filter(group -> Objects.equals(group.getDegreeType(), degreeType) && Objects.equals(group.getDegree(), degree)).findAny();
    }
}

