/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Date;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.OldMarkSheet_Base;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.MarkSheetPredicates;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.joda.time.DateTime;

public class OldMarkSheet
extends OldMarkSheet_Base {
    protected OldMarkSheet() {
    }

    public OldMarkSheet(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, MarkSheetState markSheetState, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person creator) {
        this();
        this.checkParameters(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, markSheetState, evaluationBeans, creator);
        this.init(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, markSheetState, Boolean.FALSE, creator);
        for (MarkSheetEnrolmentEvaluationBean evaluationBean : evaluationBeans) {
            this.addEnrolmentEvaluationToMarkSheet(responsibleTeacher, evaluationBean);
        }
        this.generateCheckSum();
    }

    private void addEnrolmentEvaluationToMarkSheet(Teacher responsibleTeacher, MarkSheetEnrolmentEvaluationBean evaluationBean) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        EnrolmentEvaluation enrolmentEvaluation = evaluationBean.getEnrolment().getEnrolmentEvaluationBySeason(this.getEvaluationSeason()).filter(e -> e.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.TEMPORARY_OBJ) || e.isNotEvaluated()).findAny().orElse(null);
        if (enrolmentEvaluation == null) {
            enrolmentEvaluation = evaluationBean.getEnrolment().addNewEnrolmentEvaluation(EnrolmentEvaluationState.TEMPORARY_OBJ, this.getEvaluationSeason(), responsibleTeacher.getPerson(), evaluationBean.getGradeValue(), this.getCreationDate(), evaluationBean.getEvaluationDate(), this.getExecutionPeriod(), null);
        } else {
            enrolmentEvaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
            enrolmentEvaluation.edit(responsibleTeacher.getPerson(), evaluationBean.getGradeValue(), this.getCreationDate(), evaluationBean.getEvaluationDate());
        }
        this.addEnrolmentEvaluations(enrolmentEvaluation);
    }

    private void checkParameters(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, MarkSheetState markSheetState, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person person) {
        if (curricularCourse == null || executionSemester == null || responsibleTeacher == null || evaluationDate == null || season == null || markSheetState == null || person == null) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (evaluationBeans == null || evaluationBeans.size() == 0) {
            throw new DomainException("error.markSheet.create.with.invalid.enrolmentEvaluations.number", new String[0]);
        }
    }

    public void confirm(Person validator) {
        AccessControl.check(this, MarkSheetPredicates.confirmPredicate);
        if (validator == null) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (this.isNotConfirmed()) {
            this.setValidator(validator);
            for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationsSet()) {
                enrolmentEvaluation.confirmSubmission(this.getEnrolmentEvaluationStateToConfirm(), validator, "");
            }
        } else {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        this.setConfirmationDateDateTime(new DateTime());
        this.setMarkSheetState(this.getMarkSheetStateToConfirm());
    }

    protected void appendEnrolmentEvaluations(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans) {
        for (MarkSheetEnrolmentEvaluationBean evaluationBean : evaluationBeans) {
            this.addEnrolmentEvaluationToMarkSheet(this.getResponsibleTeacher(), evaluationBean);
        }
    }

    protected void editEnrolmentEvaluations(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToEdit) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        for (MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean : evaluationBeansToEdit) {
            if (this.getEnrolmentEvaluationsSet().contains((Object)enrolmentEvaluationBean.getEnrolmentEvaluation())) {
                EnrolmentEvaluation enrolmentEvaluation = enrolmentEvaluationBean.getEnrolmentEvaluation();
                enrolmentEvaluation.edit(this.getResponsibleTeacher().getPerson(), enrolmentEvaluationBean.getGradeValue(), new Date(), enrolmentEvaluationBean.getEvaluationDate());
                continue;
            }
            throw new DomainException("error.markSheet", new String[0]);
        }
    }

    protected void checkIfEvaluationDateIsInExamsPeriod(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, Date evaluationDate, EvaluationSeason season) throws DomainException {
    }

    protected void checkIfTeacherIsResponsibleOrCoordinator(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, EvaluationSeason season) throws DomainException {
    }
}

