/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.DocumentType;
import org.fenixedu.academic.domain.GraduationType;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.domain.GuideSituation;
import org.fenixedu.academic.domain.GuideState;
import org.fenixedu.academic.domain.Guide_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.YearMonthDay;

public class Guide
extends Guide_Base {
    public static Comparator<Guide> COMPARATOR_BY_VERSION = new Comparator<Guide>(){

        @Override
        public int compare(Guide leftGuide, Guide rightGuide) {
            int comparationResult = leftGuide.getVersion().compareTo(rightGuide.getVersion());
            return comparationResult == 0 ? leftGuide.getExternalId().compareTo(rightGuide.getExternalId()) : comparationResult;
        }
    };
    public static final Comparator<Guide> yearAndNumberComparator = new Comparator<Guide>(){

        @Override
        public int compare(Guide g1, Guide g2) {
            Integer yearComparation = g1.getYear().compareTo(g2.getYear());
            if (yearComparation == 0) {
                return g1.getNumber().compareTo(g2.getNumber());
            }
            return yearComparation;
        }
    };

    public Guide() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getGuideEntriesSet().isEmpty() || !this.getGuideSituationsSet().isEmpty() || this.getVersion() == 1) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"guide.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public GuideSituation getActiveSituation() {
        if (this.getGuideSituationsSet() != null) {
            for (GuideSituation guideSituation : this.getGuideSituationsSet()) {
                if (!guideSituation.getState().getState().equals(1)) continue;
                return guideSituation;
            }
        }
        return null;
    }

    public void updateTotalValue() {
        BigDecimal total = BigDecimal.ZERO;
        for (GuideEntry guideEntry : this.getGuideEntriesSet()) {
            total = total.add(guideEntry.getPriceBigDecimal().multiply(BigDecimal.valueOf(guideEntry.getQuantity().intValue())));
        }
        total.setScale(2, RoundingMode.HALF_EVEN);
        this.setTotalBigDecimal(total);
    }

    public GuideEntry getEntry(GraduationType graduationType, DocumentType documentType, String description) {
        for (GuideEntry entry : this.getGuideEntriesSet()) {
            if (graduationType == null || !graduationType.equals((Object)entry.getGraduationType()) || documentType == null || !documentType.equals((Object)entry.getDocumentType()) || description == null || !description.equals(entry.getDescription())) continue;
            return entry;
        }
        return null;
    }

    public static Integer generateGuideNumber() {
        return Collections.max(Bennu.getInstance().getGuidesSet(), yearAndNumberComparator).getNumber() + 1;
    }

    public static Guide readByNumberAndYearAndVersion(Integer number, Integer year, Integer version) {
        for (Guide guide : Bennu.getInstance().getGuidesSet()) {
            if (!guide.getNumber().equals(number) || !guide.getYear().equals(year) || !guide.getVersion().equals(version)) continue;
            return guide;
        }
        return null;
    }

    public static Guide readLastVersionByNumberAndYear(Integer number, Integer year) {
        HashSet<Guide> result = new HashSet<Guide>();
        for (Guide guide : Bennu.getInstance().getGuidesSet()) {
            if (!guide.getYear().equals(year) || !guide.getNumber().equals(number)) continue;
            result.add(guide);
        }
        if (result.isEmpty()) {
            return null;
        }
        return Collections.max(result, COMPARATOR_BY_VERSION);
    }

    public static List<Guide> readByNumberAndYear(Integer number, Integer year) {
        ArrayList<Guide> guides = new ArrayList<Guide>();
        for (Guide guide : Bennu.getInstance().getGuidesSet()) {
            if (!guide.getYear().equals(year) || !guide.getNumber().equals(number)) continue;
            guides.add(guide);
        }
        Collections.sort(guides, new BeanComparator("version"));
        return guides;
    }

    public static List<Guide> readByYear(Integer year) {
        ArrayList<Guide> guides = new ArrayList<Guide>();
        for (Guide guide : Bennu.getInstance().getGuidesSet()) {
            if (!guide.getYear().equals(year)) continue;
            guides.add(guide);
        }
        return guides;
    }

    public static List<Guide> readByYearAndState(Integer guideYear, GuideState situationOfGuide) {
        ArrayList<Guide> result = new ArrayList<Guide>();
        for (Guide guide : Bennu.getInstance().getGuidesSet()) {
            GuideSituation activeSituation = guide.getActiveSituation();
            if (activeSituation == null || !activeSituation.getSituation().equals((Object)situationOfGuide) || guideYear != null && (guideYear == null || !guide.getYear().equals(guideYear))) continue;
            result.add(guide);
        }
        return result;
    }

    @Deprecated
    public void setTotal(Double total) {
        if (total != null) {
            this.setTotalBigDecimal(BigDecimal.valueOf(total));
        } else {
            this.setTotalBigDecimal(null);
        }
    }

    @Deprecated
    public Double getTotal() {
        return this.getTotalBigDecimal().doubleValue();
    }

    @Deprecated
    public Date getCreationDate() {
        YearMonthDay ymd = this.getCreationDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setCreationDate(Date date) {
        if (date == null) {
            this.setCreationDateYearMonthDay(null);
        } else {
            this.setCreationDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getPaymentDate() {
        YearMonthDay ymd = this.getPaymentDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setPaymentDate(Date date) {
        if (date == null) {
            this.setPaymentDateYearMonthDay(null);
        } else {
            this.setPaymentDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }
}

