/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;

public class CurricularYearList {
    private final List<Integer> curricularYears;
    private static Splitter SPLITTER = Splitter.on((char)',');

    public CurricularYearList(Iterable<Integer> curricularYears) {
        if (curricularYears == null) {
            throw new IllegalArgumentException("exception.null.values");
        }
        this.curricularYears = Lists.newArrayList(curricularYears);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Integer year : this.curricularYears) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(year);
        }
        return buffer.toString();
    }

    public static CurricularYearList internalize(String data) {
        Iterable years = Iterables.transform((Iterable)SPLITTER.split((CharSequence)data), (Function)new Function<String, Integer>(){

            public Integer apply(String str) {
                return Integer.parseInt(str);
            }
        });
        return new CurricularYearList(years);
    }

    public List<Integer> getYears() {
        return this.curricularYears;
    }

    public boolean hasAll() {
        return this.curricularYears.contains(-1);
    }
}

