/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public enum WeekDay {
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;


    public String getName() {
        return this.name();
    }

    public static WeekDay getWeekDay(DiaSemana weekDay) {
        switch (weekDay.getDiaSemana()) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        return null;
    }

    public static WeekDay fromJodaTimeToWeekDay(DateTime date) {
        int dayOfWeek = date.dayOfWeek().get();
        switch (dayOfWeek) {
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
            case 7: {
                return SUNDAY;
            }
        }
        return null;
    }

    public String getLabel() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.name(), (String[])new String[0]);
    }

    public String getLabelShort() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)(this.name() + ".short"), (String[])new String[0]);
    }
}

