/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.ConversationMessage;
import org.fenixedu.academic.domain.messaging.ConversationThread;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.dto.messaging.CreateConversationMessageBean;
import org.fenixedu.academic.dto.messaging.CreateConversationThreadAndMessageBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.messaging.AddForumEmailSubscriber;
import org.fenixedu.academic.service.services.messaging.CreateConversationMessage;
import org.fenixedu.academic.service.services.messaging.CreateConversationThreadAndMessage;
import org.fenixedu.academic.service.services.messaging.RemoveForumEmailSubscriber;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.utils.RequestUtils;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

public abstract class ForunsManagement
extends FenixDispatchAction {
    private static final Integer DEFAULT_PAGE_SIZE = 20;

    public ActionForward viewForum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.prepareViewForum(request);
        return mapping.findForward("viewForum");
    }

    public ActionForward prepareCreateThreadAndMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute("forum", (Object)this.getRequestedForum(request));
        request.setAttribute("person", (Object)this.getLoggedPerson(request));
        return mapping.findForward("createThreadAndMessage");
    }

    public ActionForward createThreadAndMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CreateConversationThreadAndMessageBean createConversationThreadAndMessageBean = (CreateConversationThreadAndMessageBean)RenderUtils.getViewState((String)"createThreadAndMessage").getMetaObject().getObject();
        try {
            CreateConversationThreadAndMessage.runCreateConversationThreadAndMessage(createConversationThreadAndMessageBean);
        }
        catch (DomainException e) {
            ActionMessages actionMessages = new ActionMessages();
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getKey()));
            this.saveMessages(request, actionMessages);
            return this.prepareCreateThreadAndMessage(mapping, form, request, response);
        }
        return this.viewForum(mapping, form, request, response);
    }

    private ActionForward viewThreadOnPage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, Integer pageNumber) throws FenixServiceException {
        ConversationThread thread = this.getRequestedThread(request);
        request.setAttribute("thread", (Object)thread);
        request.setAttribute("pageNumber", (Object)pageNumber);
        request.setAttribute("pageNumbers", (Object)this.computeNumberOfPages(DEFAULT_PAGE_SIZE, thread.getMessageSet().size()));
        request.setAttribute("messages", this.getContentToDisplay(thread.getMessageSet(), pageNumber, DEFAULT_PAGE_SIZE));
        Person loggedPerson = this.getLoggedPerson(request);
        request.setAttribute("person", (Object)loggedPerson);
        Forum forum = this.getRequestedForum(request);
        request.setAttribute("forum", (Object)this.getRequestedForum(request));
        request.setAttribute("loggedPersonCanWrite", (Object)forum.getWritersGroup().isMember(Authenticate.getUser()));
        request.setAttribute("showReplyBox", (Object)this.getShowReplyBox(request));
        return mapping.findForward("viewThread");
    }

    public ActionForward viewThread(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, IOException {
        if (this.getLoggedPerson(request) == null) {
            RequestUtils.sendLoginRedirect(request, response);
            return null;
        }
        return this.viewThreadOnPage(mapping, actionForm, request, response, this.getPageNumber(request));
    }

    public ActionForward prepareCreateMessage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute("quotationText", (Object)this.getQuotationText(request));
        return this.viewThreadOnPage(mapping, actionForm, request, response, this.computeNumberOfPages(DEFAULT_PAGE_SIZE, this.getRequestedThread(request).getMessageSet().size()));
    }

    public ActionForward createMessage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CreateConversationMessageBean createConversationMessageBean = (CreateConversationMessageBean)RenderUtils.getViewState((String)"createMessage").getMetaObject().getObject();
        try {
            CreateConversationMessage.runCreateConversationMessage(createConversationMessageBean);
        }
        catch (DomainException e) {
            ActionMessages actionMessages = new ActionMessages();
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getKey()));
            this.saveMessages(request, actionMessages);
            return this.prepareCreateMessage(mapping, actionForm, request, response);
        }
        return this.viewThreadOnPage(mapping, actionForm, request, response, this.computeNumberOfPages(DEFAULT_PAGE_SIZE, this.getRequestedThread(request).getMessageSet().size()));
    }

    public ActionForward emailSubscribe(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        AddForumEmailSubscriber.run(this.getRequestedForum(request), this.getLoggedPerson(request));
        this.prepareViewForum(request);
        return mapping.findForward("viewForum");
    }

    public ActionForward emailUnsubscribe(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RemoveForumEmailSubscriber.run(this.getRequestedForum(request), this.getLoggedPerson(request));
        this.prepareViewForum(request);
        return mapping.findForward("viewForum");
    }

    protected String getQuotedMessageId(HttpServletRequest request) {
        return request.getParameter("quoteMessageId");
    }

    protected Integer getPageNumber(HttpServletRequest request) {
        String pageNumberString = request.getParameter("pageNumber");
        return pageNumberString != null ? Integer.valueOf(pageNumberString) : 1;
    }

    protected Boolean getShowReplyBox(HttpServletRequest request) {
        return Boolean.valueOf(request.getParameter("showReplyBox"));
    }

    protected ConversationThread getRequestedThread(HttpServletRequest request) {
        return (ConversationThread)FenixFramework.getDomainObject((String)request.getParameter("threadId"));
    }

    protected Forum getRequestedForum(HttpServletRequest request) {
        return (Forum)FenixFramework.getDomainObject((String)request.getParameter("forumId"));
    }

    private <T extends Comparable<T>> List<T> getContentToDisplay(Collection<T> messages, Integer pageNumber, Integer pageSize) {
        ArrayList<T> nodeCopy = new ArrayList<T>(messages);
        Collections.sort(nodeCopy);
        int start = (pageNumber - 1) * pageSize;
        return nodeCopy.subList(start, Math.min(nodeCopy.size(), start + pageSize));
    }

    private int computeNumberOfPages(Integer pageSize, int listSize) {
        int totalPages = (int)StrictMath.ceil((double)listSize / Double.valueOf(pageSize.intValue()));
        return totalPages;
    }

    private MultiLanguageString getQuotationText(HttpServletRequest request) {
        String quotedMessageId = this.getQuotedMessageId(request);
        String quotationText = null;
        if (quotedMessageId != null) {
            MessageResources resources = this.getResources(request, "MESSAGING_RESOURCES");
            ConversationMessage message = (ConversationMessage)FenixFramework.getDomainObject((String)quotedMessageId);
            String author = message.getCreator().getName() + " (" + message.getCreator().getUsername() + ")";
            quotationText = resources.getMessage(this.getLocale(request), "messaging.viewThread.quotationText", (Object)author, (Object)message.getBody().getContent());
        }
        return new MultiLanguageString(quotationText);
    }

    private void prepareViewForum(HttpServletRequest request) throws FenixServiceException {
        Forum forum = this.getRequestedForum(request);
        request.setAttribute("forum", (Object)forum);
        Integer pageNumber = this.getPageNumber(request);
        request.setAttribute("pageNumber", (Object)pageNumber);
        request.setAttribute("conversationThreads", this.getContentToDisplay(forum.getConversationThreadSet(), pageNumber, DEFAULT_PAGE_SIZE));
        request.setAttribute("pageNumbers", (Object)this.computeNumberOfPages(DEFAULT_PAGE_SIZE, forum.getConversationThreadSet().size()));
        Person loggedPerson = this.getLoggedPerson(request);
        request.setAttribute("receivingMessagesByEmail", (Object)forum.isPersonReceivingMessagesByEmail(loggedPerson));
        request.setAttribute("loggedPersonCanWrite", (Object)forum.getWritersGroup().isMember(Authenticate.getUser()));
    }
}

