/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidate.degree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.installments.InstallmentForFirstTimeStudents;
import org.fenixedu.academic.domain.accounting.paymentCodes.InstallmentPaymentCode;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySummaryFile;
import org.fenixedu.academic.domain.candidacy.FirstTimeCandidacyStage;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.workflow.CandidacyOperation;
import org.fenixedu.academic.domain.candidacy.workflow.PrintAllDocumentsOperation;
import org.fenixedu.academic.domain.candidacy.workflow.form.ResidenceInformationForm;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.workflow.Form;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.service.services.candidacy.ExecuteStateOperation;
import org.fenixedu.academic.service.services.candidacy.LogFirstTimeCandidacyTimestamp;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.ReadStudentTimeTable;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.candidate.ViewCandidaciesDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

@Mapping(path="/degreeCandidacyManagement", module="candidate", functionality=ViewCandidaciesDispatchAction.class)
@Forwards(value={@Forward(name="showWelcome", path="/candidate/degree/showWelcome.jsp"), @Forward(name="showCandidacyDetails", path="/candidate/degree/showCandidacyDetails.jsp"), @Forward(name="fillData", path="/candidate/degree/fillData.jsp"), @Forward(name="showData", path="/candidate/degree/showData.jsp"), @Forward(name="showOperationFinished", path="/candidate/degree/showOperationFinished.jsp"), @Forward(name="printSchedule", path="/commons/student/timeTable/classTimeTable.jsp"), @Forward(name="printRegistrationDeclaration", path="/candidate/degree/printRegistrationDeclaration.jsp"), @Forward(name="printSystemAccessData", path="/candidate/degree/printSystemAccessData.jsp"), @Forward(name="printUnder23TransportsDeclation", path="/candidate/degree/printUnder23TransportsDeclaration.jsp"), @Forward(name="printMeasurementTestDate", path="/candidate/degree/printMeasurementTestDate.jsp"), @Forward(name="printAllDocuments", path="/candidate/degree/printAllDocuments.jsp")})
public class DegreeCandidacyManagementDispatchAction
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(DegreeCandidacyManagementDispatchAction.class);

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("showWelcome");
    }

    public ActionForward showCandidacyDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        StudentCandidacy candidacy = this.getCandidacy(request);
        request.setAttribute("candidacy", (Object)candidacy);
        TreeSet<Operation> operations = new TreeSet<Operation>();
        operations.addAll(candidacy.getActiveCandidacySituation().getOperationsForPerson(this.getLoggedPerson(request)));
        request.setAttribute("operations", operations);
        request.setAttribute("person", (Object)DegreeCandidacyManagementDispatchAction.getUserView(request).getPerson());
        return mapping.findForward("showCandidacyDetails");
    }

    public ActionForward doOperation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        CandidacyOperation operation = (CandidacyOperation)this.getCandidacy(request).getActiveCandidacySituation().getOperationByTypeAndPerson(this.getOperationType(request), this.getLoggedPerson(request));
        request.setAttribute("operation", (Object)operation);
        request.setAttribute("candidacy", (Object)this.getCandidacy(request));
        if (operation != null && operation.isInput()) {
            LogFirstTimeCandidacyTimestamp.logTimestamp(this.getCandidacy(request), FirstTimeCandidacyStage.STARTED_FILLING_FORMS);
            request.setAttribute("currentForm", (Object)operation.moveToNextForm());
            return mapping.findForward("fillData");
        }
        return this.executeOperation(mapping, form, request, response, operation);
    }

    public ActionForward processForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        request.setAttribute("candidacy", (Object)this.getCandidacy(request));
        CandidacyOperation operation = (CandidacyOperation)RenderUtils.getViewState((String)"operation-view-state").getMetaObject().getObject();
        request.setAttribute("operation", (Object)operation);
        if (!this.validateCurrentForm(request)) {
            return mapping.findForward("fillData");
        }
        if (operation.hasMoreForms()) {
            request.setAttribute("currentForm", (Object)operation.moveToNextForm());
            return mapping.findForward("fillData");
        }
        StudentCandidacy candidacy = this.getCandidacy(request);
        if (candidacy.isConcluded()) {
            request.setAttribute("candidacyID", (Object)candidacy.getExternalId());
            this.addActionMessage(request, "warning.candidacy.process.is.already.concluded");
            return this.showCandidacyDetails(mapping, actionForm, request, response);
        }
        this.executeOperation(mapping, actionForm, request, response, operation);
        LogFirstTimeCandidacyTimestamp.logTimestamp(candidacy, FirstTimeCandidacyStage.FINISHED_FILLING_FORMS);
        return new ActionForward(this.buildSummaryPdfGeneratorURL(request, candidacy), true);
    }

    private boolean validateCurrentForm(HttpServletRequest request) {
        Form form = (Form)RenderUtils.getViewState((String)("fillData" + this.getCurrentFormPosition(request))).getMetaObject().getObject();
        List<LabelFormatter> messages = form.validate();
        if (!messages.isEmpty()) {
            request.setAttribute("formMessages", (Object)this.solveLabelFormatterArgs(request, messages.toArray(new LabelFormatter[messages.size()])));
            request.setAttribute("currentForm", (Object)form);
            return false;
        }
        return true;
    }

    private ActionForward executeOperation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, CandidacyOperation candidacyOperation) throws FenixServiceException, FenixActionException {
        User userView = DegreeCandidacyManagementDispatchAction.getUserView(request);
        if (candidacyOperation == null) {
            candidacyOperation = new PrintAllDocumentsOperation(RoleType.STUDENT, (Candidacy)((Object)this.getCandidacy(request)));
        } else {
            ExecuteStateOperation.run(candidacyOperation, this.getLoggedPerson(request));
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_SCHEDULE) {
            List<InfoShowOccupation> infoLessons = ReadStudentTimeTable.run(this.getCandidacy(request).getRegistration(), null);
            request.setAttribute("person", (Object)this.getCandidacy(request).getPerson());
            request.setAttribute("infoLessons", infoLessons);
            return mapping.findForward("printSchedule");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_REGISTRATION_DECLARATION) {
            request.setAttribute("registration", (Object)this.getCandidacy(request).getRegistration());
            request.setAttribute("executionYear", (Object)this.getCandidacy(request).getExecutionDegree().getExecutionYear());
            return mapping.findForward("printRegistrationDeclaration");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_UNDER_23_TRANSPORTS_DECLARATION) {
            request.setAttribute("person", (Object)this.getCandidacy(request).getRegistration().getPerson());
            request.setAttribute("campus", (Object)this.getCandidacy(request).getRegistration().getCampus().getName());
            request.setAttribute("executionYear", (Object)this.getCandidacy(request).getExecutionDegree().getExecutionYear());
            return mapping.findForward("printUnder23TransportsDeclation");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_MEASUREMENT_TEST_DATE) {
            request.setAttribute("registration", (Object)this.getCandidacy(request).getRegistration());
            return mapping.findForward("printMeasurementTestDate");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_ALL_DOCUMENTS) {
            StudentCandidacy candidacy = this.getCandidacy(request);
            request.setAttribute("candidacy", (Object)candidacy);
            request.setAttribute("registration", (Object)candidacy.getRegistration());
            request.setAttribute("executionYear", (Object)candidacy.getExecutionDegree().getExecutionYear());
            request.setAttribute("person", (Object)candidacy.getRegistration().getPerson());
            request.setAttribute("campus", (Object)candidacy.getRegistration().getCampus().getName());
            request.setAttribute("administrativeOfficeFeeAndInsurancePaymentCode", this.administrativeOfficeFeeAndInsurancePaymentCode(candidacy.getAvailablePaymentCodesSet()));
            request.setAttribute("installmentPaymentCodes", this.installmmentPaymentCodes(candidacy.getAvailablePaymentCodesSet()));
            request.setAttribute("totalGratuityPaymentCode", this.totalGratuityPaymentCode(candidacy.getAvailablePaymentCodesSet()));
            request.setAttribute("firstInstallmentEndDate", (Object)this.calculateFirstInstallmentEndDate(candidacy.getRegistration(), this.getCandidacy(request).getAvailablePaymentCodesSet()));
            request.setAttribute("sibsEntityCode", (Object)FenixEduAcademicConfiguration.getConfiguration().getSibsEntityCode());
            List<InfoShowOccupation> infoLessons = ReadStudentTimeTable.run(candidacy.getRegistration(), null);
            request.setAttribute("infoLessons", infoLessons);
            return mapping.findForward("printAllDocuments");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.PRINT_SYSTEM_ACCESS_DATA) {
            request.setAttribute("person", (Object)userView.getPerson());
            return mapping.findForward("printSystemAccessData");
        }
        if (candidacyOperation.getType() == CandidacyOperationType.FILL_PERSONAL_DATA) {
            request.setAttribute("aditionalInformation", (Object)this.getResources(request).getMessage("label.candidacy.username.changed.message", (Object)userView.getPerson().getUsername(), (Object)Unit.getInstitutionAcronym()));
        } else if (candidacyOperation.getType() == CandidacyOperationType.PRINT_GRATUITY_PAYMENT_CODES) {
            request.setAttribute("registration", (Object)this.getCandidacy(request).getRegistration());
            request.setAttribute("paymentCodes", (Object)this.getCandidacy(request).getAvailablePaymentCodesSet());
            request.setAttribute("sibsEntityCode", (Object)FenixEduAcademicConfiguration.getConfiguration().getSibsEntityCode());
            request.setAttribute("administrativeOfficeFeeAndInsurancePaymentCode", this.administrativeOfficeFeeAndInsurancePaymentCode(this.getCandidacy(request).getAvailablePaymentCodesSet()));
            request.setAttribute("installmentPaymentCodes", this.installmmentPaymentCodes(this.getCandidacy(request).getAvailablePaymentCodesSet()));
            request.setAttribute("totalGratuityPaymentCode", this.totalGratuityPaymentCode(this.getCandidacy(request).getAvailablePaymentCodesSet()));
            request.setAttribute("firstInstallmentEndDate", (Object)this.calculateFirstInstallmentEndDate(this.getCandidacy(request).getRegistration(), this.getCandidacy(request).getAvailablePaymentCodesSet()));
            return mapping.findForward("printGratuityPaymentCodes");
        }
        request.setAttribute("candidacyID", (Object)candidacyOperation.getCandidacy().getExternalId());
        return this.showCandidacyDetails(mapping, form, request, response);
    }

    private Object totalGratuityPaymentCode(Collection<PaymentCode> availablePaymentCodes) {
        for (PaymentCode paymentCode : availablePaymentCodes) {
            if (!PaymentCodeType.GRATUITY_FIRST_INSTALLMENT.equals((Object)paymentCode.getType()) || paymentCode instanceof InstallmentPaymentCode) continue;
            return paymentCode;
        }
        return null;
    }

    private Object installmmentPaymentCodes(Collection<PaymentCode> availablePaymentCodes) {
        ArrayList installmentPaymentCodes = new ArrayList();
        CollectionUtils.select(availablePaymentCodes, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                PaymentCode paymentCode = (PaymentCode)((Object)arg0);
                return paymentCode instanceof InstallmentPaymentCode;
            }
        }, installmentPaymentCodes);
        Collections.sort(installmentPaymentCodes, new BeanComparator("code"));
        return installmentPaymentCodes;
    }

    private Object administrativeOfficeFeeAndInsurancePaymentCode(Collection<PaymentCode> availablePaymentCodes) {
        for (PaymentCode paymentCode : availablePaymentCodes) {
            if (!PaymentCodeType.ADMINISTRATIVE_OFFICE_FEE_AND_INSURANCE.equals((Object)paymentCode.getType())) continue;
            return paymentCode;
        }
        return null;
    }

    private YearMonthDay calculateFirstInstallmentEndDate(Registration registration, Collection<PaymentCode> availablePaymentCodes) {
        for (PaymentCode paymentCode : availablePaymentCodes) {
            InstallmentPaymentCode installmentPaymentCode;
            if (!paymentCode.isInstallmentPaymentCode() || !(installmentPaymentCode = (InstallmentPaymentCode)((Object)paymentCode)).getInstallment().isForFirstTimeStudents()) continue;
            InstallmentForFirstTimeStudents firstInstallment = (InstallmentForFirstTimeStudents)((Object)installmentPaymentCode.getInstallment());
            return registration.getStartDate().plusDays(firstInstallment.getNumberOfDaysToStartApplyingPenalty().intValue());
        }
        return null;
    }

    public ActionForward showCurrentForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        request.setAttribute("candidacy", (Object)this.getCandidacy(request));
        request.setAttribute("operation", RenderUtils.getViewState((String)"operation-view-state").getMetaObject().getObject());
        Form form = (Form)RenderUtils.getViewState((String)("fillData" + this.getCurrentFormPosition(request))).getMetaObject().getObject();
        request.setAttribute("currentForm", (Object)form);
        if (this.isPostback(request)) {
            if (this.getFromRequest(request, "country") != null) {
                ResidenceInformationForm rif = (ResidenceInformationForm)form;
                rif.setDistrictSubdivisionOfResidence(null);
            }
            RenderUtils.invalidateViewState();
        }
        return mapping.findForward("fillData");
    }

    private boolean isPostback(HttpServletRequest request) {
        return request.getParameter("postback") != null && Boolean.valueOf(request.getParameter("postback")).equals(Boolean.TRUE);
    }

    private StudentCandidacy getCandidacy(HttpServletRequest request) {
        return (StudentCandidacy)((Object)this.getDomainObject(request, "candidacyID"));
    }

    private Integer getCurrentFormPosition(HttpServletRequest request) {
        String requestParameter = request.getParameter("currentFormPosition");
        if (!StringUtils.isEmpty((String)requestParameter)) {
            return Integer.valueOf(requestParameter);
        }
        return null;
    }

    private CandidacyOperationType getOperationType(HttpServletRequest request) {
        return CandidacyOperationType.valueOf(this.getFromRequest(request, "operationType").toString());
    }

    private String buildSummaryPdfGeneratorURL(HttpServletRequest request, StudentCandidacy candidacy) {
        String url = "/candidate/degreeCandidacyManagement.do?method=doOperation&operationType=PRINT_ALL_DOCUMENTS&candidacyID=" + candidacy.getExternalId();
        String urlWithChecksum = GenericChecksumRewriter.injectChecksumInUrl((String)request.getContextPath(), (String)url, (HttpSession)request.getSession(false));
        return urlWithChecksum.substring("/candidate".length());
    }

    public ActionForward generateSummaryFile(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return new ActionForward(this.buildSummaryPdfGeneratorURL(request, this.getCandidacy(request)), true);
    }

    public ActionForward showSummaryFile(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CandidacySummaryFile file = this.getCandidacy(request).getSummaryFile();
        response.reset();
        try {
            response.getOutputStream().write(file.getContent());
            response.setContentLength(file.getContent().length);
            response.setContentType("application/pdf");
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

