/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.EditCandidacyInformationDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.StudentRegistrationDA;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/student", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="viewStudentDetails", path="/academicAdminOffice/student/viewStudentDetails.jsp"), @Forward(name="editPersonalData", path="/academicAdminOffice/editPersonalData.jsp"), @Forward(name="viewPersonalData", path="/academicAdminOffice/viewPersonalData.jsp"), @Forward(name="viewStudentLogChanges", path="/academicAdminOffice/viewStudentLogChanges.jsp")})
public class StudentDA
extends StudentRegistrationDA {
    private Student getAndSetStudent(HttpServletRequest request) {
        String studentID = this.getFromRequest(request, "studentID").toString();
        Student student = (Student)FenixFramework.getDomainObject((String)studentID);
        request.setAttribute("student", (Object)student);
        request.setAttribute("choosePhdOrRegistration", (Object)new EditCandidacyInformationDA.ChooseRegistrationOrPhd(student));
        return student;
    }

    public ActionForward prepareEditPersonalData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getAndSetStudent(request);
        request.setAttribute("personBean", (Object)new PersonBeanFactoryEditor(student.getPerson()));
        return mapping.findForward("editPersonalData");
    }

    public ActionForward editPersonalDataPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetStudent(request);
        request.setAttribute("personBean", this.getRenderedObject());
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPersonalData");
    }

    public ActionForward editPersonalDataInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetStudent(request);
        request.setAttribute("personBean", this.getRenderedObject());
        return mapping.findForward("editPersonalData");
    }

    public ActionForward editPersonalData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.getAndSetStudent(request);
        try {
            this.executeFactoryMethod();
            RenderUtils.invalidateViewState();
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("personBean", this.getRenderedObject());
            return mapping.findForward("editPersonalData");
        }
        this.addActionMessage(request, "message.student.personDataEditedWithSuccess");
        return mapping.findForward("viewStudentDetails");
    }

    public ActionForward viewPersonalData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("personBean", (Object)new PersonBeanFactoryEditor(this.getAndSetStudent(request).getPerson()));
        return mapping.findForward("viewPersonalData");
    }

    public ActionForward visualizeStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetStudent(request);
        return mapping.findForward("viewStudentDetails");
    }

    public ActionForward viewStudentLog(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getAndSetStudent(request);
        Person person = student.getPerson();
        Set logsList = person.getPersonInformationLogsSet();
        request.setAttribute("person", (Object)person);
        request.setAttribute("logsList", (Object)logsList);
        return mapping.findForward("viewStudentLogChanges");
    }

    public static class PersonBeanFactoryEditor
    extends PersonBean
    implements FactoryExecutor {
        public PersonBeanFactoryEditor(Person person) {
            super(person);
        }

        @Override
        public Object execute() {
            this.getPerson().editPersonalInformation(this);
            return null;
        }
    }
}

