/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher.authorization;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$createCategory;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$createTeacherAuthorization;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$createTeacherCategory;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$editCategory;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$importAuthorizations;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService$callable$revoke;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.CategoryBean;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.CsvService;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.FormBean;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.SearchBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class AuthorizationService {
    @Autowired
    private CsvService csvService;
    @Autowired
    private MessageSource messageSource;
    public static final Advice advice$createTeacherAuthorization = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createTeacherCategory = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$revoke = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createCategory = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$editCategory = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$importAuthorizations = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    private String message(String code, Object ... args) {
        return this.messageSource.getMessage(code, args, I18N.getLocale());
    }

    public List<Department> getDepartments() {
        return Department.readActiveDepartments();
    }

    public List<TeacherCategory> getCategories() {
        return Bennu.getInstance().getTeacherCategorySet().stream().distinct().sorted().collect(Collectors.toList());
    }

    public List<ExecutionSemester> getExecutionPeriods() {
        return Bennu.getInstance().getExecutionPeriodsSet().stream().distinct().sorted(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR.reversed()).collect(Collectors.toList());
    }

    public List<ExecutionSemester> getExecutionPeriods(Teacher teacher) {
        return teacher.getTeacherAuthorizationStream().map(TeacherAuthorization::getExecutionSemester).distinct().sorted(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR.reversed()).collect(Collectors.toList());
    }

    public ExecutionSemester getCurrentPeriod() {
        return ExecutionSemester.readActualExecutionSemester();
    }

    public TeacherAuthorization createTeacherAuthorization(FormBean bean) {
        return this.createTeacherAuthorization(bean.getUser(), bean.getDepartment(), bean.getPeriod(), bean.getCategory(), bean.getContracted(), bean.getLessonHours(), bean.getWorkPercentageInInstitution());
    }

    public TeacherAuthorization createTeacherAuthorization(User user, Department department, ExecutionSemester executionSemester, TeacherCategory teacherCategory, Boolean bl, Double d, Double d2) {
        return (TeacherAuthorization)advice$createTeacherAuthorization.perform((Callable)new AuthorizationService$callable$createTeacherAuthorization(this, user, department, executionSemester, teacherCategory, bl, d, d2));
    }

    static /* synthetic */ TeacherAuthorization advised$createTeacherAuthorization(AuthorizationService this_, User user, Department department, ExecutionSemester semester, TeacherCategory category, Boolean contracted, Double lessonHours, Double workPercentageInInstitution) {
        Teacher teacher = user.getPerson().getTeacher() == null ? new Teacher(user.getPerson()) : user.getPerson().getTeacher();
        return TeacherAuthorization.createOrUpdate(teacher, department, semester, category, contracted, lessonHours, workPercentageInInstitution);
    }

    public TeacherCategory createTeacherCategory(String string, LocalizedString localizedString, Integer n) {
        return (TeacherCategory)advice$createTeacherCategory.perform((Callable)new AuthorizationService$callable$createTeacherCategory(this, string, localizedString, n));
    }

    static /* synthetic */ TeacherCategory advised$createTeacherCategory(AuthorizationService this_, String code, LocalizedString name, Integer weight) {
        return new TeacherCategory(code, name, weight);
    }

    private Stream<TeacherAuthorization> getAuthorizations(Department department) {
        if (department == null) {
            return Bennu.getInstance().getTeacherAuthorizationSet().stream();
        }
        return department.getTeacherAuthorizationStream();
    }

    public List<TeacherAuthorization> getRevokedAuthorizations() {
        Comparator byRevokeTime = (a1, a2) -> a1.getRevokeTime().compareTo((ReadableInstant)a2.getRevokeTime());
        return Bennu.getInstance().getRevokedTeacherAuthorizationSet().stream().distinct().sorted(byRevokeTime.reversed()).collect(Collectors.toList());
    }

    public List<TeacherAuthorization> searchAuthorizations(SearchBean search) {
        return this.getAuthorizations(search.getDepartment()).filter(t -> t.getExecutionSemester().equals(search.getPeriod())).distinct().collect(Collectors.toList());
    }

    public void revoke(TeacherAuthorization teacherAuthorization) {
        Object object = advice$revoke.perform((Callable)new AuthorizationService$callable$revoke(this, teacherAuthorization));
    }

    static /* synthetic */ void advised$revoke(AuthorizationService this_, TeacherAuthorization authorization) {
        authorization.revoke();
    }

    public void createCategory(CategoryBean categoryBean) {
        Object object = advice$createCategory.perform((Callable)new AuthorizationService$callable$createCategory(this, categoryBean));
    }

    static /* synthetic */ void advised$createCategory(AuthorizationService this_, CategoryBean form) {
        new TeacherCategory(form.getCode(), form.getName(), form.getWeight());
    }

    public void editCategory(TeacherCategory teacherCategory, CategoryBean categoryBean) {
        Object object = advice$editCategory.perform((Callable)new AuthorizationService$callable$editCategory(this, teacherCategory, categoryBean));
    }

    static /* synthetic */ void advised$editCategory(AuthorizationService this_, TeacherCategory category, CategoryBean form) {
        category.setCode(form.getCode());
        category.setName(form.getName());
        category.setWeight(form.getWeight());
    }

    public void dumpCSV(SearchBean search, OutputStream out) throws IOException {
        SpreadsheetBuilder builder = new SpreadsheetBuilder();
        builder.addSheet(this.getSheetName(search), (SheetData)new SheetData<TeacherAuthorization>(this.searchAuthorizations(search)){

            protected void makeLine(TeacherAuthorization item) {
                User user = item.getTeacher().getPerson().getUser();
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.1.username", new Object[0]), user.getUsername());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.2.categoryCode", new Object[0]), item.getTeacherCategory().getCode());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.3.departmentAcronym", new Object[0]), item.getDepartment().getAcronym());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.4.lessonHours", new Object[0]), item.getLessonHours());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.5.contracted", new Object[0]), item.isContracted() ? "Y" : "N");
                this.addCell(AuthorizationService.this.message("teacher.authorizations.csv.column.6.workPercentageInInstitution", new Object[0]), item.getWorkPercentageInInstitution());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.displayname", new Object[0]), user.getProfile().getDisplayName());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.category", new Object[0]), item.getTeacherCategory().getName().getContent());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.department", new Object[0]), item.getDepartment().getNameI18n().getContent());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.period", new Object[0]), item.getExecutionSemester().getQualifiedName());
                this.addCell(AuthorizationService.this.message("teacher.authorizations.authorized", new Object[0]), String.format("%s (%s)", item.getAuthorizer().getProfile().getDisplayName(), item.getAuthorizer().getUsername()));
            }
        });
        builder.build(WorkbookExportFormat.CSV, out);
    }

    public String getCsvFilename(SearchBean search) {
        return this.getSheetName(search);
    }

    public String getSheetName(SearchBean search) {
        String department = search.getDepartment() == null ? this.message("label.all", new Object[0]) : search.getDepartment().getAcronym();
        String period = search.getPeriod().getQualifiedName().replace(" ", "_");
        return Joiner.on((String)"_").join((Object)"teacherAuthorizations", (Object)department, new Object[]{period});
    }

    public List<TeacherAuthorization> importCSV(ExecutionSemester period, MultipartFile partFile) {
        try {
            return this.importAuthorizations(period, this.csvService.readCsvFile(partFile.getInputStream(), ",", Charsets.UTF_8.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(this.message("teacher.authorizations.upload.parsing.failed", new Object[0]));
        }
    }

    private List<TeacherAuthorization> importAuthorizations(ExecutionSemester executionSemester, List<Map<String, String>> list) {
        return (List)advice$importAuthorizations.perform((Callable)new AuthorizationService$callable$importAuthorizations(this, executionSemester, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$importAuthorizations(AuthorizationService this_, ExecutionSemester period, List authorizationEntries) {
        return authorizationEntries.stream().map(auth -> {
            Double lessonHours;
            String username = (String)auth.get(this.message("teacher.authorizations.csv.column.1.username", new Object[0]));
            String categoryCode = (String)auth.get(this.message("teacher.authorizations.csv.column.2.categoryCode", new Object[0]));
            String departmentAcronym = (String)auth.get(this.message("teacher.authorizations.csv.column.3.departmentAcronym", new Object[0]));
            String hoursValue = (String)auth.get(this.message("teacher.authorizations.csv.column.4.lessonHours", new Object[0]));
            String contractedValue = (String)auth.get(this.message("teacher.authorizations.csv.column.5.contracted", new Object[0]));
            String workPercentageInInstitutionValue = (String)auth.get(this.message("teacher.authorizations.csv.column.6.workPercentageInInstitution", new Object[0]));
            if (Strings.isNullOrEmpty((String)username) && Strings.isNullOrEmpty((String)categoryCode) && Strings.isNullOrEmpty((String)departmentAcronym) && Strings.isNullOrEmpty((String)hoursValue) && Strings.isNullOrEmpty((String)contractedValue) && Strings.isNullOrEmpty((String)workPercentageInInstitutionValue)) {
                return Optional.empty();
            }
            User user = User.findByUsername((String)username);
            if (user == null) {
                throw new RuntimeException(this.message("teacher.authorizations.csv.column.1.username.error", username));
            }
            Optional<TeacherCategory> category = TeacherCategory.findByCode(categoryCode);
            if (!category.isPresent()) {
                throw new RuntimeException(this.message("teacher.authorizations.csv.column.2.categoryCode.error", categoryCode));
            }
            Department department = Department.find(departmentAcronym);
            if (department == null) {
                throw new RuntimeException(this.message("teacher.authorizations.csv.column.3.departmentAcronym.error", departmentAcronym));
            }
            try {
                lessonHours = Double.parseDouble(hoursValue);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(this.message("teacher.authorizations.csv.column.4.lessonHours.error", hoursValue));
            }
            if (!"Y".equals(contractedValue) && !"N".equals(contractedValue)) {
                throw new RuntimeException(this.message("teacher.authorizations.csv.column.5.contracted.error", contractedValue));
            }
            Boolean contracted = new Boolean("Y".equals(contractedValue));
            Double workPercentageInInstitution = null;
            if (StringUtils.isNotBlank((String)workPercentageInInstitutionValue)) {
                try {
                    workPercentageInInstitution = Double.parseDouble(workPercentageInInstitutionValue);
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException(this.message("teacher.authorizations.csv.column.6.workPercentageInInstitution.error", workPercentageInInstitutionValue));
                }
            }
            return Optional.of(this.createTeacherAuthorization(user, department, period, category.get(), contracted, lessonHours, workPercentageInInstitution));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

