/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator.evaluation;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.ui.faces.bean.coordinator.evaluation.CoordinatorEvaluationManagementBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CoordinatorProjectsInformationBackingBean
extends CoordinatorEvaluationManagementBackingBean {
    private List<ExecutionCourse> executionCoursesWithProjects;
    private List<ExecutionCourse> executionCoursesWithoutProjects;
    private final Map<String, List<Project>> projects = new HashMap<String, List<Project>>();
    private List<CalendarLink> projectsCalendarLink;

    private void filterExecutionCourses() {
        if (this.executionCoursesWithProjects == null || this.executionCoursesWithoutProjects == null) {
            this.executionCoursesWithProjects = new ArrayList<ExecutionCourse>();
            this.executionCoursesWithoutProjects = new ArrayList<ExecutionCourse>();
            Collections.sort(this.getExecutionCourses(), new BeanComparator("sigla"));
            this.projects.clear();
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                List<Project> associatedProjects = executionCourse.getAssociatedProjects();
                if (!executionCourse.getAssociatedProjects().isEmpty()) {
                    Collections.sort(associatedProjects, new BeanComparator("begin"));
                    this.executionCoursesWithProjects.add(executionCourse);
                    this.projects.put(executionCourse.getExternalId(), associatedProjects);
                    continue;
                }
                this.executionCoursesWithoutProjects.add(executionCourse);
            }
        }
    }

    public List<CalendarLink> getProjectsCalendarLink() {
        if (this.projectsCalendarLink == null) {
            this.projectsCalendarLink = new ArrayList<CalendarLink>();
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            for (ExecutionCourse executionCourse : this.getExecutionCoursesWithProjects()) {
                for (Project project : executionCourse.getAssociatedProjects()) {
                    CalendarLink calendarLinkBegin = new CalendarLink();
                    calendarLinkBegin.setObjectOccurrence(project.getBegin());
                    StringBuilder linkLabel = new StringBuilder(20);
                    linkLabel.append(executionCourse.getSigla());
                    linkLabel.append(" (").append(sdf.format(project.getBegin())).append(")");
                    linkLabel.append("<br/>").append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.coordinator.enrolmentBegin", (String[])new String[0]));
                    calendarLinkBegin.setObjectLinkLabel(linkLabel.toString());
                    CalendarLink calendarLinkEnd = new CalendarLink();
                    calendarLinkEnd.setObjectOccurrence(project.getEnd());
                    linkLabel = new StringBuilder(20);
                    linkLabel.append(executionCourse.getSigla());
                    linkLabel.append(" (").append(sdf.format(project.getEnd())).append(")");
                    linkLabel.append("<br/>").append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.delivery", (String[])new String[0]));
                    calendarLinkEnd.setObjectLinkLabel(linkLabel.toString());
                    HashMap<String, String> linkParameters = new HashMap<String, String>();
                    linkParameters.put("degreeCurricularPlanID", this.getDegreeCurricularPlanID().toString());
                    linkParameters.put("executionPeriodID", this.getExecutionPeriodID().toString());
                    linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
                    linkParameters.put("curricularYearID", this.getCurricularYearID().toString());
                    linkParameters.put("evaluationID", project.getExternalId().toString());
                    calendarLinkBegin.setLinkParameters(linkParameters);
                    calendarLinkEnd.setLinkParameters(linkParameters);
                    this.projectsCalendarLink.add(calendarLinkBegin);
                    this.projectsCalendarLink.add(calendarLinkEnd);
                }
            }
        }
        return this.projectsCalendarLink;
    }

    public List<ExecutionCourse> getExecutionCoursesWithProjects() {
        this.filterExecutionCourses();
        return this.executionCoursesWithProjects;
    }

    public List<ExecutionCourse> getExecutionCoursesWithoutProjects() {
        this.filterExecutionCourses();
        return this.executionCoursesWithoutProjects;
    }

    public Map<String, List<Project>> getProjects() {
        return this.projects;
    }

    @Override
    protected void clearAttributes() {
        super.clearAttributes();
        this.executionCoursesWithProjects = null;
        this.executionCoursesWithoutProjects = null;
    }
}

