/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.dto.commons.CurricularCourseByExecutionSemesterBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.bolonhaManager.AddContextToCurricularCourse;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCurricularCourse;
import org.fenixedu.academic.service.services.bolonhaManager.DeleteContextFromDegreeModule;
import org.fenixedu.academic.service.services.bolonhaManager.EditContextFromCurricularCourse;
import org.fenixedu.academic.service.services.bolonhaManager.EditCurricularCourse;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class CurricularCourseManagementBackingBean
extends FenixBackingBean {
    protected final String NO_SELECTION_STRING = "-1";
    protected final Integer NO_SELECTION_INTEGER = -1;
    private String competenceCourseID = null;
    private String courseGroupID = null;
    private Integer curricularYearID = null;
    private Integer curricularSemesterID = null;
    private String contextID = null;
    private String curricularCourseID = null;
    private String executionPeriodOID = null;
    private boolean resetCompetenceCourseID = false;
    private boolean toDelete = false;
    private Double weight = null;
    private String prerequisites;
    private String prerequisitesEn;
    private CompetenceCourse competenceCourse = null;
    private DegreeCurricularPlan degreeCurricularPlan = null;
    private CurricularCourse curricularCourse = null;
    private Context context = null;
    public List<SelectItem> departmentUnits = null;
    public List<SelectItem> courseGroups = null;
    public List<SelectItem> curricularCourses = null;
    public List<SelectItem> executionYearItems = null;
    private CurricularCourseByExecutionSemesterBean curricularCourseSemesterBean = null;

    public CurricularCourseManagementBackingBean() {
        if (this.getCurricularCourse() != null && this.getExecutionYear() != null) {
            this.curricularCourseSemesterBean = new CurricularCourseByExecutionSemesterBean(this.getCurricularCourse(), ExecutionSemester.readBySemesterAndExecutionYear(2, this.getExecutionYear().getYear()));
        }
    }

    public CurricularCourseByExecutionSemesterBean getCurricularCourseSemesterBean() {
        return this.curricularCourseSemesterBean;
    }

    public void setCurricularCourseSemesterBean(CurricularCourseByExecutionSemesterBean curricularCourseSemesterBean) {
        this.curricularCourseSemesterBean = curricularCourseSemesterBean;
    }

    public String getDegreeCurricularPlanID() {
        DegreeCoordinatorIndex.setCoordinatorContext(this.getRequest());
        String degreeCurricularPlanId = this.getAndHoldStringParameter("degreeCurricularPlanID");
        if (Strings.isNullOrEmpty((String)degreeCurricularPlanId)) {
            degreeCurricularPlanId = this.getCurricularCourse().getDegreeCurricularPlan().getExternalId();
        }
        return degreeCurricularPlanId;
    }

    public String getAction() {
        return this.getAndHoldStringParameter("action");
    }

    public String getShowRules() {
        return this.getAndHoldStringParameter("showRules");
    }

    public String getToOrder() {
        return this.getAndHoldStringParameter("toOrder");
    }

    public String getOrganizeBy() {
        return this.getAndHoldStringParameter("organizeBy");
    }

    public String getHideCourses() {
        return this.getAndHoldStringParameter("hideCourses");
    }

    public String getContextID() {
        return this.contextID == null ? (this.contextID = this.getAndHoldStringParameter("contextID")) : this.contextID;
    }

    public void setContextID(String contextID) {
        this.contextID = contextID;
    }

    public String getContextIDToDelete() {
        return this.getAndHoldStringParameter("contextIDToDelete");
    }

    public String getCourseGroupID() {
        if (this.courseGroupID == null) {
            this.courseGroupID = this.getAndHoldStringParameter("courseGroupID");
            if (this.courseGroupID == null) {
                this.courseGroupID = this.getContext(this.getContextID()) != null ? this.getContext(this.getContextID()).getParentCourseGroup().getExternalId() : this.courseGroupID;
            }
        }
        return this.courseGroupID;
    }

    public void setCourseGroupID(String courseGroupID) {
        this.courseGroupID = courseGroupID;
    }

    public String getCurricularCourseID() {
        return this.curricularCourseID == null ? (this.curricularCourseID = this.getAndHoldStringParameter("curricularCourseID")) : this.curricularCourseID;
    }

    public void setCurricularCourseID(String curricularCourseID) {
        this.curricularCourseID = curricularCourseID;
    }

    public String getExecutionPeriodOID() {
        return this.executionPeriodOID == null ? (this.executionPeriodOID = this.getAndHoldStringParameter("executionPeriodOID")) : this.executionPeriodOID;
    }

    public void setExecutionPeriodOID(String executionPeriodOID) {
        this.executionPeriodOID = executionPeriodOID;
    }

    public String getDepartmentUnitID() {
        if (this.getViewState().getAttribute("departmentUnitID") == null && this.getCurricularCourse() != null) {
            this.getViewState().setAttribute("departmentUnitID", this.getCurricularCourse().getCompetenceCourse().getDepartmentUnit().getExternalId());
        }
        return (String)this.getViewState().getAttribute("departmentUnitID");
    }

    public void setDepartmentUnitID(String departmentUnitID) {
        this.getViewState().setAttribute("departmentUnitID", departmentUnitID);
    }

    public String getCompetenceCourseID() {
        if (this.competenceCourseID == null && this.getCurricularCourse() != null) {
            this.competenceCourseID = this.getCurricularCourse().getCompetenceCourse().getExternalId();
        }
        return this.competenceCourseID;
    }

    public void setCompetenceCourseID(String competenceCourseID) {
        this.competenceCourseID = this.resetCompetenceCourseID ? null : competenceCourseID;
    }

    public List<SelectItem> getDepartmentUnits() {
        return this.departmentUnits == null ? (this.departmentUnits = this.readDepartmentUnits()) : this.departmentUnits;
    }

    public List<SelectItem> getAllowedDepartmentUnits() {
        return this.departmentUnits == null ? (this.departmentUnits = this.readAllowedDepartmentUnits()) : this.departmentUnits;
    }

    public List<SelectItem> getCompetenceCourses() {
        return this.readCompetenceCourses();
    }

    public List<SelectItem> getCourseGroups() {
        return this.courseGroups == null ? (this.courseGroups = this.readDegreeModules(CourseGroup.class)) : this.courseGroups;
    }

    public List<SelectItem> getCurricularCourses() {
        return this.curricularCourses == null ? (this.curricularCourses = this.readDegreeModules(CurricularCourse.class)) : this.curricularCourses;
    }

    public List<SelectItem> getCurricularYears() {
        int years = this.getDegreeCurricularPlan().getDurationInYears();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(years);
        result.add(new SelectItem((Object)this.NO_SELECTION_INTEGER, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        for (int i = 1; i <= years; ++i) {
            result.add(new SelectItem((Object)i, String.valueOf(i) + BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.context.period.sign", (String[])new String[0])));
        }
        return result;
    }

    public List<SelectItem> getCurricularSemesters() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(2);
        result.add(new SelectItem((Object)this.NO_SELECTION_INTEGER, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        result.add(new SelectItem((Object)1, String.valueOf(1) + BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.context.period.sign", (String[])new String[0])));
        result.add(new SelectItem((Object)2, String.valueOf(2) + BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.context.period.sign", (String[])new String[0])));
        return result;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan == null ? (this.degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDegreeCurricularPlanID())) : this.degreeCurricularPlan;
    }

    public List<String> getGroupMembersLabels() {
        ArrayList<String> result = new ArrayList<String>();
        Group curricularPlanMembersGroup = this.getDegreeCurricularPlan().getCurricularPlanMembersGroup();
        if (curricularPlanMembersGroup != null) {
            for (User user : curricularPlanMembersGroup.getMembers()) {
                result.add(user.getPerson().getName() + " (" + user.getUsername() + ")");
            }
        }
        return result;
    }

    public CourseGroup getCourseGroup() {
        return (CourseGroup)FenixFramework.getDomainObject((String)this.getCourseGroupID());
    }

    public DepartmentUnit getDepartmentUnit() {
        if (this.getDepartmentUnitID() != null && !this.getDepartmentUnitID().equals("-1")) {
            return (DepartmentUnit)FenixFramework.getDomainObject((String)this.getDepartmentUnitID());
        }
        return null;
    }

    public CompetenceCourse getCompetenceCourse() {
        if (this.competenceCourse == null && this.getCompetenceCourseID() != null && !this.getCompetenceCourseID().equals("-1")) {
            this.competenceCourse = (CompetenceCourse)FenixFramework.getDomainObject((String)this.getCompetenceCourseID());
        }
        return this.competenceCourse;
    }

    public CurricularCourse getCurricularCourse() {
        return this.curricularCourse == null && this.getCurricularCourseID() != null ? (this.curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)this.getCurricularCourseID())) : this.curricularCourse;
    }

    protected Context getContext(String contextID) {
        return this.context == null && contextID != null ? (this.context = (Context)FenixFramework.getDomainObject((String)contextID)) : this.context;
    }

    public void resetCompetenceCourse(ValueChangeEvent event) {
        this.resetCompetenceCourseID = true;
    }

    public Double getWeight() {
        if (this.weight == null) {
            this.weight = this.getCurricularCourse() != null ? this.getCurricularCourse().getWeigth() : Double.valueOf(0.0);
        }
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public String getPrerequisites() {
        if (this.prerequisites == null && this.getCurricularCourse() != null) {
            this.prerequisites = this.getCurricularCourse().getPrerequisites();
        }
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String getPrerequisitesEn() {
        if (this.prerequisitesEn == null && this.getCurricularCourse() != null) {
            this.prerequisitesEn = this.getCurricularCourse().getPrerequisitesEn();
        }
        return this.prerequisitesEn;
    }

    public void setPrerequisitesEn(String prerequisitesEn) {
        this.prerequisitesEn = prerequisitesEn;
    }

    public Integer getCurricularYearID() {
        if (this.curricularYearID == null && this.getContext(this.getContextID()) != null) {
            this.curricularYearID = this.getContext(this.getContextID()).getCurricularPeriod().getOrderByType(AcademicPeriod.YEAR);
            if (this.curricularYearID == null) {
                this.curricularYearID = 1;
            }
        } else if (this.curricularYearID == null && this.getAndHoldIntegerParameter("curricularYearID") != null) {
            this.curricularYearID = this.getAndHoldIntegerParameter("curricularYearID");
        }
        return this.curricularYearID;
    }

    public void setCurricularYearID(Integer curricularYearID) {
        this.curricularYearID = curricularYearID;
    }

    public Integer getCurricularSemesterID() {
        if (this.curricularSemesterID == null && this.getContext(this.getContextID()) != null) {
            this.curricularSemesterID = this.getContext(this.getContextID()).getCurricularPeriod().getOrderByType(AcademicPeriod.SEMESTER);
        } else if (this.curricularSemesterID == null && this.getAndHoldIntegerParameter("curricularSemesterID") != null) {
            this.curricularSemesterID = this.getAndHoldIntegerParameter("curricularSemesterID");
        }
        return this.curricularSemesterID;
    }

    public void setCurricularSemesterID(Integer curricularSemesterID) {
        this.curricularSemesterID = curricularSemesterID;
    }

    public String getSelectedCurricularCourseType() {
        if (this.getViewState().getAttribute("selectedCurricularCourseType") == null) {
            if (this.getCurricularCourse() != null) {
                this.setSelectedCurricularCourseType(this.getCurricularCourse().getType().name());
            } else {
                this.setSelectedCurricularCourseType(CurricularCourseType.NORMAL_COURSE.name());
            }
        }
        return (String)this.getViewState().getAttribute("selectedCurricularCourseType");
    }

    public void setSelectedCurricularCourseType(String selectedCurricularCourseType) {
        this.getViewState().setAttribute("selectedCurricularCourseType", selectedCurricularCourseType);
    }

    public String getName() {
        if (this.getViewState().getAttribute("name") == null && this.getCurricularCourse() != null) {
            this.setName(this.getCurricularCourse().getName());
        }
        return (String)this.getViewState().getAttribute("name");
    }

    public void setName(String name) {
        this.getViewState().setAttribute("name", name);
    }

    public String getNameEn() {
        if (this.getViewState().getAttribute("nameEn") == null && this.getCurricularCourse() != null && !StringUtils.isEmpty((String)this.getCurricularCourse().getNameEn())) {
            this.setNameEn(this.getCurricularCourse().getNameEn());
        }
        return (String)this.getViewState().getAttribute("nameEn");
    }

    public void setNameEn(String nameEn) {
        this.getViewState().setAttribute("nameEn", nameEn);
    }

    public List<String> getRulesLabels() {
        ArrayList<String> resultLabels = new ArrayList<String>();
        for (CurricularRule curricularRule : this.getCurricularCourse().getParticipatingCurricularRules()) {
            resultLabels.add(CurricularRuleLabelFormatter.getLabel(curricularRule));
        }
        return resultLabels;
    }

    public boolean isToDelete() {
        if (this.getCurricularCourse() != null) {
            this.toDelete = this.getCurricularCourse().getParentContextsSet().size() == 1;
        }
        return this.toDelete;
    }

    protected boolean isBolonha() {
        return this.getDegreeCurricularPlan().isBolonhaDegree();
    }

    public String getExecutionYearID() {
        if (this.getViewState().getAttribute("executionYearID") == null && this.getAndHoldStringParameter("executionYearID") != null) {
            this.setExecutionYearID(this.getAndHoldStringParameter("executionYearID"));
        }
        return (String)this.getViewState().getAttribute("executionYearID");
    }

    public void setExecutionYearID(String executionYearID) {
        this.getViewState().setAttribute("executionYearID", executionYearID);
    }

    public ExecutionYear getExecutionYear() {
        String executionYearId = this.getExecutionYearID();
        ExecutionYear oldestContextExecutionYear = this.getDegreeCurricularPlan().getOldestContextExecutionYear();
        if (executionYearId != null) {
            return (ExecutionYear)FenixFramework.getDomainObject((String)executionYearId);
        }
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (oldestContextExecutionYear != null && oldestContextExecutionYear.isAfter(currentExecutionYear)) {
            return oldestContextExecutionYear;
        }
        return currentExecutionYear;
    }

    protected InfoExecutionYear getCurrentExecutionYear() {
        return InfoExecutionYear.newInfoFromDomain(ExecutionYear.readCurrentExecutionYear());
    }

    public List<SelectItem> getExecutionYearItems() {
        return this.executionYearItems == null ? (this.executionYearItems = this.readExecutionYearItems()) : this.executionYearItems;
    }

    public String getBeginExecutionPeriodID() {
        if (this.getViewState().getAttribute("beginExecutionPeriodID") == null && this.getContext(this.getContextID()) != null) {
            this.setBeginExecutionPeriodID(this.getContext(this.getContextID()).getBeginExecutionPeriod().getExternalId());
        }
        return (String)this.getViewState().getAttribute("beginExecutionPeriodID");
    }

    public void setBeginExecutionPeriodID(String beginExecutionPeriodID) {
        this.getViewState().setAttribute("beginExecutionPeriodID", beginExecutionPeriodID);
    }

    public String getEndExecutionPeriodID() {
        if (this.getViewState().getAttribute("endExecutionPeriodID") == null && this.getContext(this.getContextID()) != null) {
            this.setEndExecutionPeriodID(this.getContext(this.getContextID()).getEndExecutionPeriod() != null ? this.getContext(this.getContextID()).getEndExecutionPeriod().getExternalId() : "-1");
        }
        return (String)this.getViewState().getAttribute("endExecutionPeriodID");
    }

    public void setEndExecutionPeriodID(String endExecutionPeriodID) {
        this.getViewState().setAttribute("endExecutionPeriodID", endExecutionPeriodID);
    }

    public List<SelectItem> getBeginExecutionPeriodItems() {
        return this.readExecutionPeriodItems();
    }

    public List<SelectItem> getEndExecutionPeriodItems() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(this.readExecutionPeriodItems());
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"opened", (String[])new String[0])));
        return result;
    }

    protected List<SelectItem> readExecutionPeriodItems() {
        ExecutionSemester minimumExecutionPeriod = this.getMinimumExecutionPeriod();
        List<ExecutionSemester> notClosedExecutionPeriods = ExecutionSemester.readNotClosedExecutionPeriods();
        Collections.sort(notClosedExecutionPeriods);
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionSemester notClosedExecutionPeriod : notClosedExecutionPeriods) {
            if (minimumExecutionPeriod != null && !notClosedExecutionPeriod.isAfterOrEquals(minimumExecutionPeriod)) continue;
            result.add(new SelectItem((Object)notClosedExecutionPeriod.getExternalId(), notClosedExecutionPeriod.getName() + " " + notClosedExecutionPeriod.getExecutionYear().getYear()));
        }
        return result;
    }

    protected ExecutionSemester getMinimumExecutionPeriod() {
        return this.getCourseGroup() == null ? null : this.getCourseGroup().getMinimumExecutionPeriod();
    }

    public List<Context> getCurricularCourseParentContexts() {
        return this.getCurricularCourse().getParentContextsByExecutionYear(this.getExecutionYear());
    }

    public String createCurricularCourse() {
        try {
            this.checkCourseGroup();
            this.checkCurricularSemesterAndYear();
            this.runCreateCurricularCourse();
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"general.error", (String[])new String[0]));
            return "buildCurricularPlan";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularCourseCreated", (String[])new String[0]));
        return "buildCurricularPlan";
    }

    private void runCreateCurricularCourse() throws FenixActionException, FenixServiceException {
        CurricularCourseType curricularCourseType = CurricularCourseType.valueOf(this.getSelectedCurricularCourseType());
        if (curricularCourseType.equals((Object)CurricularCourseType.NORMAL_COURSE)) {
            this.checkCompetenceCourse();
            CreateCurricularCourse.run(new CreateCurricularCourse.CreateCurricularCourseArgs(this.getWeight(), this.getPrerequisites(), this.getPrerequisitesEn(), this.getCompetenceCourseID(), this.getCourseGroupID(), this.getCurricularYearID(), this.getCurricularSemesterID(), this.getDegreeCurricularPlanID(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID()));
        } else if (curricularCourseType.equals((Object)CurricularCourseType.OPTIONAL_COURSE)) {
            this.checkCurricularCourseNameAndNameEn();
            CreateCurricularCourse.run(new CreateCurricularCourse.CreateOptionalCurricularCourseArgs(this.getDegreeCurricularPlanID(), this.getCourseGroupID(), this.getName(), this.getNameEn(), this.getCurricularYearID(), this.getCurricularSemesterID(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID()));
        }
    }

    public String editCurricularCourse() {
        try {
            this.runEditCurricularCourse();
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularCourseEdited", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setContextID(null);
        return "";
    }

    private void runEditCurricularCourse() throws FenixActionException, FenixServiceException {
        CurricularCourseType curricularCourseType = CurricularCourseType.valueOf(this.getSelectedCurricularCourseType());
        if (curricularCourseType.equals((Object)CurricularCourseType.NORMAL_COURSE)) {
            this.checkCompetenceCourse();
            EditCurricularCourse.run(this.getCurricularCourse(), this.getWeight(), this.getPrerequisites(), this.getPrerequisitesEn(), this.getCompetenceCourse());
        } else if (curricularCourseType.equals((Object)CurricularCourseType.OPTIONAL_COURSE)) {
            EditCurricularCourse.run(this.getCurricularCourse(), this.getName(), this.getNameEn());
        }
    }

    private void checkCompetenceCourse() throws FenixActionException {
        if (this.getCompetenceCourseID() == null) {
            throw new FenixActionException("error.mustChooseACompetenceCourse");
        }
    }

    protected void checkCourseGroup() throws FenixActionException {
        if (this.getCourseGroupID() == null || this.getCourseGroupID().equals(this.NO_SELECTION_STRING)) {
            throw new FenixActionException("error.mustChooseACourseGroup");
        }
    }

    private void checkCurricularCourse() throws FenixActionException {
        if (this.getCurricularCourseID() == null || this.getCurricularCourseID().equals(this.NO_SELECTION_STRING)) {
            throw new FenixActionException("error.mustChooseACurricularCourse");
        }
    }

    private void checkCurricularCourseNameAndNameEn() throws FenixActionException {
        if (this.getName() == null || this.getName().equals("")) {
            throw new FenixActionException("error.mustDefineNameOrNameEn");
        }
        if (this.getNameEn() == null || this.getNameEn().equals("")) {
            throw new FenixActionException("error.mustDefineNameOrNameEn");
        }
    }

    protected void checkCurricularSemesterAndYear() throws FenixActionException {
        if (this.getCurricularSemesterID() == null || this.getCurricularSemesterID().equals(this.NO_SELECTION_INTEGER)) {
            throw new FenixActionException("error.mustChooseACurricularSemester");
        }
        if (this.getCurricularYearID() == null || this.getCurricularYearID().equals(this.NO_SELECTION_INTEGER)) {
            throw new FenixActionException("error.mustChooseACurricularYear");
        }
    }

    public void addContext(ActionEvent event) {
        this.addContext();
    }

    public String addContext() {
        try {
            this.checkCourseGroup();
            this.checkCurricularCourse();
            this.checkCurricularSemesterAndYear();
            AddContextToCurricularCourse.run(this.getCurricularCourse(), this.getCourseGroup(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID(), this.getCurricularYearID(), this.getCurricularSemesterID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"addedNewContextToCurricularCourse", (String[])new String[0]));
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])e.getArgs()));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"general.error", (String[])new String[0]));
            return "buildCurricularPlan";
        }
        this.setContextID(null);
        return "buildCurricularPlan";
    }

    public String editContext() {
        try {
            this.checkCourseGroup();
            EditContextFromCurricularCourse.run(this.getCurricularCourse(), this.getContext(this.getContextID()), this.getCourseGroup(), this.getCurricularYearID(), this.getCurricularSemesterID(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID());
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setContextID(null);
        return "";
    }

    protected String getFinalEndExecutionPeriodID() {
        return this.getViewState().getAttribute("endExecutionPeriodID") == null || this.getViewState().getAttribute("endExecutionPeriodID").equals("-1") ? null : (String)this.getViewState().getAttribute("endExecutionPeriodID");
    }

    public void tryDeleteContext(ActionEvent event) {
        if (!this.isToDelete()) {
            this.deleteContext(event);
        } else {
            this.setContextID(this.getContextIDToDelete());
        }
    }

    public void deleteContext(ActionEvent event) {
        try {
            DeleteContextFromDegreeModule.run(this.getCurricularCourseID(), this.getContextIDToDelete());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"successAction", (String[])new String[0]));
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
        }
        this.setContextID(null);
    }

    public String cancel() {
        this.setContextID(null);
        return "";
    }

    public String editCurricularCourseReturnPath() {
        return !this.toDelete ? "" : "deleteCurricularCourseContext";
    }

    private List<SelectItem> readDepartmentUnits() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (Object departmentObject : Bennu.getInstance().getDepartmentsSet()) {
            DepartmentUnit departmentUnit = ((Department)((Object)departmentObject)).getDepartmentUnit();
            result.add(new SelectItem((Object)departmentUnit.getExternalId(), departmentUnit.getName()));
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)this.NO_SELECTION_STRING, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    private List<SelectItem> readAllowedDepartmentUnits() {
        Department personDepartment;
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (Department department : Bennu.getInstance().getDepartmentsSet()) {
            if (department.getCompetenceCourseMembersGroup() == null || !department.getCompetenceCourseMembersGroup().isMember(this.getUserView())) continue;
            DepartmentUnit departmentUnit = department.getDepartmentUnit();
            result.add(new SelectItem((Object)departmentUnit.getExternalId(), departmentUnit.getName()));
        }
        Collections.sort(result, new BeanComparator("label"));
        if (result.size() == 1 && (personDepartment = this.getPersonDepartment()) != null && !((SelectItem)result.get(0)).getValue().equals(personDepartment.getDepartmentUnit().getExternalId())) {
            result.add(0, new SelectItem((Object)personDepartment.getDepartmentUnit().getExternalId(), personDepartment.getName()));
        }
        return result;
    }

    private Department getPersonDepartment() {
        User userView = this.getUserView();
        Person person = userView == null ? null : userView.getPerson();
        Teacher teacher = person == null ? null : person.getTeacher();
        return teacher == null ? null : teacher.getDepartment();
    }

    private List<SelectItem> readCompetenceCourses() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        DepartmentUnit departmentUnit = this.getDepartmentUnit();
        if (departmentUnit != null) {
            for (ScientificAreaUnit scientificAreaUnit : departmentUnit.getScientificAreaUnits()) {
                for (CompetenceCourseGroupUnit competenceCourseGroupUnit : scientificAreaUnit.getCompetenceCourseGroupUnits()) {
                    for (CompetenceCourse competenceCourse : competenceCourseGroupUnit.getCompetenceCourses()) {
                        if (competenceCourse.getCurricularStage() == CurricularStage.DRAFT) continue;
                        String code = !StringUtils.isEmpty((String)competenceCourse.getCode()) ? " [" + competenceCourse.getCode() + "]" : "";
                        result.add(new SelectItem((Object)competenceCourse.getExternalId(), competenceCourse.getName() + " (" + BundleUtil.getString((String)"resources.EnumerationResources", (String)competenceCourse.getCurricularStage().getName(), (String[])new String[0]) + ")" + code));
                    }
                }
            }
            Collections.sort(result, new BeanComparator("label"));
        }
        result.add(0, new SelectItem((Object)this.NO_SELECTION_STRING, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    private List<SelectItem> readDegreeModules(Class<? extends DegreeModule> clazz) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        List<List<DegreeModule>> degreeModulesSet = this.getDegreeCurricularPlan().getDcpDegreeModulesIncludingFullPath(clazz, this.getExecutionYear());
        for (List<DegreeModule> degreeModules : degreeModulesSet) {
            StringBuilder pathName = new StringBuilder();
            for (DegreeModule degreeModule : degreeModules) {
                pathName.append(pathName.length() == 0 ? "" : " > ").append(degreeModule.getName());
            }
            result.add(new SelectItem((Object)degreeModules.get(degreeModules.size() - 1).getExternalId(), pathName.toString()));
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)this.NO_SELECTION_STRING, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    protected List<SelectItem> readExecutionYearItems() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        Set executionDegrees = this.getDegreeCurricularPlan().getExecutionDegreesSet();
        if (executionDegrees.isEmpty()) {
            ExecutionYear executionYear = this.getDegreeCurricularPlan().getRoot().getMinimumExecutionPeriod().getExecutionYear();
            result.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
            return result;
        }
        for (ExecutionDegree executionDegree : executionDegrees) {
            result.add(new SelectItem((Object)executionDegree.getExecutionYear().getExternalId(), executionDegree.getExecutionYear().getYear()));
        }
        if (this.getExecutionYearID() == null) {
            this.setExecutionYearID(this.getDegreeCurricularPlan().getMostRecentExecutionDegree().getExecutionYear().getExternalId());
        }
        return result;
    }

    public Degree getDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public String getDegreePresentationName() {
        return this.getDegree().getPresentationName(this.getExecutionYear());
    }

    public List<CompetenceCourse> getDegreeCurricularPlanCompetenceCourses() {
        return this.getDegreeCurricularPlan().getCompetenceCourses(this.getExecutionYear());
    }

    public ExecutionSemester getBeginExecutionPeriod() {
        return (ExecutionSemester)FenixFramework.getDomainObject((String)this.getBeginExecutionPeriodID());
    }

    public ExecutionSemester getEndExecutionPeriod() {
        return this.getEndExecutionPeriodID() == null ? null : (ExecutionSemester)FenixFramework.getDomainObject((String)this.getEndExecutionPeriodID());
    }
}

