/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager.exams;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.GOPSendMessageService;
import org.fenixedu.academic.service.filter.EditWrittenEvaluationAuthorization;
import org.fenixedu.academic.service.filter.ExecutionCourseCoordinatorAuthorizationFilter;
import org.fenixedu.academic.service.filter.ExecutionCourseLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.filter.ResourceAllocationManagerAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.EditWrittenEvaluation$callable$runEditWrittenEvaluation;
import org.fenixedu.academic.util.Season;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EditWrittenEvaluation {
    private static final EditWrittenEvaluation serviceInstance;
    public static final Advice advice$runEditWrittenEvaluation;

    protected void run(String executionCourseID, Date writtenEvaluationDate, Date writtenEvaluationStartTime, Date writtenEvaluationEndTime, List<String> executionCourseIDs, List<String> degreeModuleScopeIDs, List<String> roomIDs, String writtenEvaluationOID, Season examSeason, String writtenTestDescription, GradeScale gradeScale) throws FenixServiceException {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        WrittenEvaluation writtenEvaluation = (WrittenEvaluation)FenixFramework.getDomainObject((String)writtenEvaluationOID);
        if (writtenEvaluation == null) {
            throw new FenixServiceException("error.noWrittenEvaluation");
        }
        List<ExecutionCourse> executionCoursesToAssociate = this.readExecutionCourses(executionCourseIDs);
        List<DegreeModuleScope> degreeModuleScopeToAssociate = this.readCurricularCourseScopesAndContexts(degreeModuleScopeIDs);
        List<Space> roomsToAssociate = null;
        if (roomIDs != null) {
            roomsToAssociate = this.readRooms(roomIDs);
        }
        Signal.emit((String)"academic.writtenevaluation.edited", (Object)((Object)new EditWrittenEvaluationEvent(writtenEvaluation, writtenEvaluationDate, writtenEvaluationStartTime)));
        List<Space> previousRooms = writtenEvaluation.getAssociatedRooms();
        if (examSeason != null) {
            ((Exam)((Object)writtenEvaluation)).edit(writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCoursesToAssociate, degreeModuleScopeToAssociate, roomsToAssociate, gradeScale, examSeason);
        } else if (writtenTestDescription != null) {
            WrittenTest writtenTest = (WrittenTest)((Object)writtenEvaluation);
            Date prevTestDate = writtenTest.getDayDate();
            Date prevStartTime = writtenTest.getBeginningDate();
            Date prevTestEnd = writtenTest.getEndDate();
            writtenTest.edit(writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCoursesToAssociate, degreeModuleScopeToAssociate, roomsToAssociate, gradeScale, writtenTestDescription);
            if (!(writtenTest.getRequestRoomSentDate() == null || prevTestDate.equals(writtenEvaluationDate) && prevStartTime.equals(writtenEvaluationStartTime) && prevTestEnd.equals(writtenEvaluationEndTime) || RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(AccessControl.getPerson().getUser()))) {
                GOPSendMessageService.requestChangeRoom(writtenTest, prevTestDate, prevStartTime, prevTestEnd);
            }
        } else {
            throw new InvalidArgumentsServiceException();
        }
        if (roomsToAssociate != null) {
            for (Space allocatableSpace : roomsToAssociate) {
                int intervalCount = 0;
                DateTime beginDateTime = new DateTime(writtenEvaluationStartTime.getTime()).withSecondOfMinute(0).withMillisOfSecond(0);
                DateTime endDateTime = new DateTime(writtenEvaluationEndTime.getTime()).withSecondOfMinute(0).withMillisOfSecond(0);
                for (Occupation occupation : allocatableSpace.getOccupationSet()) {
                    EventSpaceOccupation eventSpaceOccupation;
                    List<Interval> intervals;
                    if (!(occupation instanceof EventSpaceOccupation) || (intervalCount += (intervals = (eventSpaceOccupation = (EventSpaceOccupation)occupation).getEventSpaceOccupationIntervals(beginDateTime, endDateTime)).size()) <= 1) continue;
                    throw new DomainException("error.noRoom", allocatableSpace.getName());
                }
            }
        }
    }

    private List<Space> readRooms(List<String> roomIDs) throws FenixServiceException {
        ArrayList<Space> result = new ArrayList<Space>();
        for (String roomID : roomIDs) {
            Space room = (Space)FenixFramework.getDomainObject((String)roomID);
            if (room == null) {
                throw new FenixServiceException("error.noRoom");
            }
            result.add(room);
        }
        return result;
    }

    private List<DegreeModuleScope> readCurricularCourseScopesAndContexts(List<String> degreeModuleScopeIDs) throws FenixServiceException {
        ArrayList<DegreeModuleScope> result = new ArrayList<DegreeModuleScope>();
        for (String key : degreeModuleScopeIDs) {
            DegreeModuleScope degreeModuleScope = DegreeModuleScope.getDegreeModuleScopeByKey(key);
            if (degreeModuleScope == null) continue;
            result.add(degreeModuleScope);
        }
        if (result.isEmpty()) {
            throw new FenixServiceException("error.invalidCurricularCourseScope");
        }
        return result;
    }

    private List<ExecutionCourse> readExecutionCourses(List<String> executionCourseIDs) throws FenixServiceException {
        if (executionCourseIDs.isEmpty()) {
            throw new FenixServiceException("error.invalidExecutionCourse");
        }
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (String executionCourseID : executionCourseIDs) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            if (executionCourse == null) {
                throw new FenixServiceException("error.invalidExecutionCourse");
            }
            result.add(executionCourse);
        }
        return result;
    }

    public static void runEditWrittenEvaluation(String string, Date date, Date date2, Date date3, List<String> list, List<String> list2, List<String> list3, String string2, Season season, String string3, GradeScale gradeScale) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runEditWrittenEvaluation.perform((Callable)new EditWrittenEvaluation$callable$runEditWrittenEvaluation(string, date, date2, date3, list, list2, list3, string2, season, string3, gradeScale));
    }

    static /* synthetic */ void advised$runEditWrittenEvaluation(String executionCourseID, Date writtenEvaluationDate, Date writtenEvaluationStartTime, Date writtenEvaluationEndTime, List<String> executionCourseIDs, List<String> degreeModuleScopeIDs, List<String> roomIDs, String writtenEvaluationOID, Season examSeason, String writtenTestDescription, GradeScale gradeScale) throws FenixServiceException, NotAuthorizedException {
        EditWrittenEvaluationAuthorization.instance.execute(writtenEvaluationOID);
        try {
            ResourceAllocationManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, writtenEvaluationOID, examSeason, writtenTestDescription, gradeScale);
        }
        catch (NotAuthorizedException ex1) {
            try {
                ExecutionCourseLecturingTeacherAuthorizationFilter.instance.execute(executionCourseID);
                serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, writtenEvaluationOID, examSeason, writtenTestDescription, gradeScale);
            }
            catch (NotAuthorizedException ex2) {
                ExecutionCourseCoordinatorAuthorizationFilter.instance.execute(executionCourseID);
                serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, writtenEvaluationOID, examSeason, writtenTestDescription, gradeScale);
            }
        }
    }

    static {
        advice$runEditWrittenEvaluation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new EditWrittenEvaluation();
    }

    public static class EditWrittenEvaluationEvent
    extends DomainObjectEvent<WrittenEvaluation> {
        private final Date dayDate;
        private final Date beginDate;

        public EditWrittenEvaluationEvent(WrittenEvaluation instance, Date dayDate, Date beginDate) {
            super((DomainObject)instance);
            this.dayDate = dayDate;
            this.beginDate = beginDate;
        }

        public Date getDayDate() {
            return this.dayDate;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }
    }
}

