/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager.executionCourseManagement;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.services.manager.CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.SeperateExecutionCourse$callable$run;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.SeperateExecutionCourse$callable$run$1;
import org.fenixedu.academic.service.utils.ExecutionCourseUtils;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SeperateExecutionCourse {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$run$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static ExecutionCourse run(ExecutionCourse executionCourse, ExecutionCourse executionCourse2, List<Shift> list, List<CurricularCourse> list2) {
        return (ExecutionCourse)((Object)advice$run.perform((Callable)new SeperateExecutionCourse$callable$run(executionCourse, executionCourse2, list, list2)));
    }

    static /* synthetic */ ExecutionCourse advised$run(ExecutionCourse originExecutionCourse, ExecutionCourse destinationExecutionCourse, List<Shift> shiftsToTransfer, List<CurricularCourse> curricularCourseToTransfer) {
        if (originExecutionCourse.getExecutionPeriod().getAcademicInterval().getEnd().isBeforeNow()) {
            throw new DomainException("error.manager.executionCourseManagement.separateCourse.closed", new String[0]);
        }
        if (curricularCourseToTransfer == null || curricularCourseToTransfer.isEmpty()) {
            throw new DomainException("error.selection.noCurricularCourse", new String[0]);
        }
        if (destinationExecutionCourse == null) {
            destinationExecutionCourse = SeperateExecutionCourse.createNewExecutionCourse(originExecutionCourse);
            ExecutionCourseUtils.copyBibliographicReference(originExecutionCourse, destinationExecutionCourse);
            ExecutionCourseUtils.copyEvaluationMethod(originExecutionCourse, destinationExecutionCourse);
        }
        if (destinationExecutionCourse.equals((Object)originExecutionCourse)) {
            throw new DomainException("error.selection.sameSourceDestinationCourse", new String[0]);
        }
        SeperateExecutionCourse.transferCurricularCourses(originExecutionCourse, destinationExecutionCourse, curricularCourseToTransfer);
        SeperateExecutionCourse.transferAttends(originExecutionCourse, destinationExecutionCourse);
        SeperateExecutionCourse.transferShifts(originExecutionCourse, destinationExecutionCourse, shiftsToTransfer);
        SeperateExecutionCourse.fixStudentShiftEnrolements(originExecutionCourse);
        SeperateExecutionCourse.fixStudentShiftEnrolements(destinationExecutionCourse);
        SeperateExecutionCourse.associateGroupings(originExecutionCourse, destinationExecutionCourse);
        return destinationExecutionCourse;
    }

    private static void transferCurricularCourses(ExecutionCourse originExecutionCourse, ExecutionCourse destinationExecutionCourse, List<CurricularCourse> curricularCoursesToTransfer) {
        if (originExecutionCourse.getAssociatedCurricularCoursesSet().size() - curricularCoursesToTransfer.size() < 1) {
            throw new DomainException("error.manager.executionCourseManagement.lastCurricularCourse", new String[0]);
        }
        for (CurricularCourse curricularCourse : curricularCoursesToTransfer) {
            originExecutionCourse.removeAssociatedCurricularCourses(curricularCourse);
            destinationExecutionCourse.addAssociatedCurricularCourses(curricularCourse);
        }
    }

    private static void transferAttends(ExecutionCourse originExecutionCourse, ExecutionCourse destinationExecutionCourse) {
        Set curricularCourses = destinationExecutionCourse.getAssociatedCurricularCoursesSet();
        ArrayList allAttends = new ArrayList(originExecutionCourse.getAttendsSet());
        for (Attends attends : allAttends) {
            Enrolment enrolment = attends.getEnrolment();
            if (enrolment == null || !curricularCourses.contains((Object)enrolment.getCurricularCourse())) continue;
            attends.setDisciplinaExecucao(destinationExecutionCourse);
        }
    }

    private static void transferShifts(ExecutionCourse originExecutionCourse, ExecutionCourse destinationExecutionCourse, List<Shift> shiftsToTransfer) {
        for (Shift shift : shiftsToTransfer) {
            Set courseLoads = shift.getCourseLoadsSet();
            Iterator iter = courseLoads.iterator();
            while (iter.hasNext()) {
                CourseLoad courseLoad = (CourseLoad)((Object)iter.next());
                CourseLoad newCourseLoad = destinationExecutionCourse.getCourseLoadByShiftType(courseLoad.getType());
                if (newCourseLoad == null) {
                    newCourseLoad = new CourseLoad(destinationExecutionCourse, courseLoad.getType(), courseLoad.getUnitQuantity(), courseLoad.getTotalQuantity());
                }
                iter.remove();
                shift.removeCourseLoads(courseLoad);
                shift.addCourseLoads(newCourseLoad);
            }
        }
    }

    private static void fixStudentShiftEnrolements(ExecutionCourse executionCourse) {
        for (Shift shift : executionCourse.getAssociatedShifts()) {
            for (Registration registration : shift.getStudentsSet()) {
                if (registration.attends(executionCourse)) continue;
                shift.removeStudents(registration);
            }
        }
    }

    private static void associateGroupings(ExecutionCourse originExecutionCourse, ExecutionCourse destinationExecutionCourse) {
        for (Grouping grouping : originExecutionCourse.getGroupings()) {
            for (StudentGroup studentGroup : grouping.getStudentGroupsSet()) {
                studentGroup.getAttendsSet().clear();
                studentGroup.delete();
            }
            grouping.delete();
        }
    }

    private static ExecutionCourse createNewExecutionCourse(ExecutionCourse originExecutionCourse) {
        String sigla = SeperateExecutionCourse.getUniqueExecutionCourseCode(originExecutionCourse.getNome(), originExecutionCourse.getExecutionPeriod(), originExecutionCourse.getSigla());
        ExecutionCourse destinationExecutionCourse = new ExecutionCourse(originExecutionCourse.getNome(), sigla, originExecutionCourse.getExecutionPeriod(), null);
        for (CourseLoad courseLoad : originExecutionCourse.getCourseLoadsSet()) {
            new CourseLoad(destinationExecutionCourse, courseLoad.getType(), courseLoad.getUnitQuantity(), courseLoad.getTotalQuantity());
        }
        for (Professorship professorship : originExecutionCourse.getProfessorshipsSet()) {
            Professorship newProfessorship = new Professorship();
            newProfessorship.setExecutionCourse(destinationExecutionCourse);
            newProfessorship.setPerson(professorship.getPerson());
            newProfessorship.setResponsibleFor(professorship.getResponsibleFor());
            professorship.getPermissions().copyPremissions(newProfessorship);
            destinationExecutionCourse.getProfessorshipsSet().add(newProfessorship);
        }
        return destinationExecutionCourse;
    }

    private static String getUniqueExecutionCourseCode(String executionCourseName, ExecutionSemester executionSemester, String originalExecutionCourseCode) {
        Set<String> executionCourseCodes = SeperateExecutionCourse.getExecutionCourseCodes(executionSemester);
        return CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod.getUniqueSigla(executionCourseCodes, originalExecutionCourseCode);
    }

    private static Set<String> getExecutionCourseCodes(ExecutionSemester executionSemester) {
        Set executionCourses = executionSemester.getAssociatedExecutionCoursesSet();
        return new HashSet<String>(CollectionUtils.collect((Collection)executionCourses, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                ExecutionCourse executionCourse = (ExecutionCourse)((Object)arg0);
                return executionCourse.getSigla().toUpperCase();
            }
        }));
    }

    boolean contains(Integer[] integerArray, Integer integer) {
        for (Integer element : integerArray) {
            if (!integer.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static ExecutionCourse run(String string, String string2, String[] stringArray, String[] stringArray2) {
        return (ExecutionCourse)((Object)advice$run$1.perform((Callable)new SeperateExecutionCourse$callable$run$1(string, string2, stringArray, stringArray2)));
    }

    static /* synthetic */ ExecutionCourse advised$run(String executionCourseId, String destinationExecutionCourseID, String[] shiftIdsToTransfer, String[] curricularCourseIdsToTransfer) {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        ExecutionCourse destinationExecutionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)destinationExecutionCourseID);
        List<Shift> shiftsToTransfer = SeperateExecutionCourse.readShiftsOIDsToTransfer(shiftIdsToTransfer);
        List<CurricularCourse> curricularCoursesToTransfer = SeperateExecutionCourse.readCurricularCoursesOIDsToTransfer(curricularCourseIdsToTransfer);
        return SeperateExecutionCourse.run(executionCourse, destinationExecutionCourse, shiftsToTransfer, curricularCoursesToTransfer);
    }

    private static List<Shift> readShiftsOIDsToTransfer(String[] shiftIdsToTransfer) {
        ArrayList<Shift> result = new ArrayList<Shift>();
        if (shiftIdsToTransfer == null) {
            return result;
        }
        for (String oid : shiftIdsToTransfer) {
            result.add((Shift)FenixFramework.getDomainObject((String)oid));
        }
        return result;
    }

    private static List<CurricularCourse> readCurricularCoursesOIDsToTransfer(String[] curricularCourseIdsToTransfer) {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        if (curricularCourseIdsToTransfer == null) {
            return result;
        }
        for (String oid : curricularCourseIdsToTransfer) {
            result.add((CurricularCourse)FenixFramework.getDomainObject((String)oid));
        }
        return result;
    }
}

