/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.coordinator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.service.filter.ResourceAllocationManagerAuthorizationFilter;
import org.fenixedu.academic.service.filter.coordinator.DegreeCurricularPlanAuthorizationFilter;
import org.fenixedu.academic.service.services.coordinator.ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear$callable$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear {
    private static final ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear serviceInstance;
    public static final Advice advice$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear;

    public List<ExecutionCourse> run(String degreeCurricularPlanID, String executionPeriodID, String curricularYearID) throws FenixServiceException {
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodID);
        if (executionSemester == null) {
            throw new FenixServiceException("error.no.executionPeriod");
        }
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        if (degreeCurricularPlan == null) {
            throw new FenixServiceException("error.coordinator.noDegreeCurricularPlan");
        }
        CurricularYear curricularYear = null;
        if (curricularYearID != null && (curricularYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearID)) == null) {
            throw new FenixServiceException("error.no.curYear");
        }
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            if (!this.belongToDegreeCurricularPlanAndCurricularYear(executionCourse, degreeCurricularPlan, curricularYear)) continue;
            result.add(executionCourse);
        }
        return result;
    }

    private boolean belongToDegreeCurricularPlanAndCurricularYear(ExecutionCourse executionCourse, DegreeCurricularPlan degreeCurricularPlan, CurricularYear curricularYear) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(curricularYear, degreeCurricularPlan, executionCourse.getExecutionPeriod())) continue;
            return true;
        }
        return false;
    }

    public static List<ExecutionCourse> runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear(String string, String string2, String string3) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear.perform((Callable)new ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear$callable$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear(string, string2, string3));
    }

    static /* synthetic */ List<ExecutionCourse> advised$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear(String degreeCurricularPlanID, String executionPeriodID, String curricularYearID) throws FenixServiceException, NotAuthorizedException {
        try {
            DegreeCurricularPlanAuthorizationFilter.instance.execute(degreeCurricularPlanID);
            return serviceInstance.run(degreeCurricularPlanID, executionPeriodID, curricularYearID);
        }
        catch (NotAuthorizedException ex1) {
            ResourceAllocationManagerAuthorizationFilter.instance.execute();
            return serviceInstance.run(degreeCurricularPlanID, executionPeriodID, curricularYearID);
        }
    }

    static {
        advice$runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear();
    }
}

