/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementSearchBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetSearchResultBean;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.SearchMarkSheets$callable$run;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SearchMarkSheets {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Map<EvaluationSeason, MarkSheetSearchResultBean> run(MarkSheetManagementSearchBean markSheetManagementSearchBean) throws InvalidArgumentsServiceException {
        return (Map)advice$run.perform((Callable)new SearchMarkSheets$callable$run(markSheetManagementSearchBean));
    }

    static /* synthetic */ Map<EvaluationSeason, MarkSheetSearchResultBean> advised$run(MarkSheetManagementSearchBean searchBean) throws InvalidArgumentsServiceException {
        CurricularCourse curricularCourse;
        if (searchBean.getTeacherId() != null) {
            searchBean.setTeacher(Teacher.readByIstId(searchBean.getTeacherId()));
        }
        if ((curricularCourse = searchBean.getCurricularCourse()) == null) {
            throw new InvalidArgumentsServiceException("error.noCurricularCourse");
        }
        Collection<MarkSheet> markSheets = curricularCourse.searchMarkSheets(searchBean.getExecutionPeriod(), searchBean.getTeacher(), searchBean.getEvaluationDate(), searchBean.getMarkSheetState(), searchBean.getEvaluationSeason());
        TreeMap<EvaluationSeason, MarkSheetSearchResultBean> result = new TreeMap<EvaluationSeason, MarkSheetSearchResultBean>();
        for (MarkSheet markSheet : markSheets) {
            SearchMarkSheets.addToMap(result, markSheet);
        }
        for (Map.Entry entry : result.entrySet()) {
            MarkSheetSearchResultBean searchResultBean = (MarkSheetSearchResultBean)entry.getValue();
            searchResultBean.setShowStatistics(!((EvaluationSeason)entry.getKey()).isSpecialAuthorization());
            if (!searchResultBean.isShowStatistics()) continue;
            searchResultBean.setTotalNumberOfStudents(SearchMarkSheets.getNumberOfStudentsNotEnrolled(searchBean, curricularCourse, entry) + searchResultBean.getNumberOfEnroledStudents());
        }
        return result;
    }

    private static int getNumberOfStudentsNotEnrolled(MarkSheetManagementSearchBean searchBean, CurricularCourse curricularCourse, Map.Entry<EvaluationSeason, MarkSheetSearchResultBean> entry) {
        int studentsNotEnrolled = curricularCourse.getEnrolmentsNotInAnyMarkSheet(entry.getKey(), searchBean.getExecutionPeriod()).size();
        return studentsNotEnrolled;
    }

    private static void addToMap(Map<EvaluationSeason, MarkSheetSearchResultBean> result, MarkSheet sheet) {
        SearchMarkSheets.getResultBeanForSeason(result, sheet.getEvaluationSeason()).addMarkSheet(sheet);
    }

    private static MarkSheetSearchResultBean getResultBeanForSeason(Map<EvaluationSeason, MarkSheetSearchResultBean> result, EvaluationSeason sheetType) {
        MarkSheetSearchResultBean markSheetSearchResultBean = result.get(sheetType);
        if (markSheetSearchResultBean == null) {
            markSheetSearchResultBean = new MarkSheetSearchResultBean();
            result.put(sheetType, markSheetSearchResultBean);
        }
        return markSheetSearchResultBean;
    }
}

