/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.thesis;

import java.io.Serializable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.HumanName;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisLibraryState;
import org.fenixedu.bennu.core.domain.Bennu;

public class ThesisSearchBean
implements Serializable {
    private static final long serialVersionUID = 4695377851319085267L;
    private String text;
    private ThesisLibraryState state;
    private ExecutionYear year;

    public ThesisSearchBean() {
        ExecutionYear last = null;
        for (Thesis thesis : Bennu.getInstance().getThesesSet()) {
            if (last != null && !thesis.getEnrolment().getExecutionYear().isAfter(last)) continue;
            last = thesis.getEnrolment().getExecutionYear();
        }
        this.setYear(last);
    }

    public ThesisSearchBean(String text, String state, String year) {
        this.text = text;
        if (state != null) {
            this.state = ThesisLibraryState.valueOf(state);
        }
        if (year != null) {
            this.setYear(ExecutionYear.readExecutionYearByName(year));
        }
    }

    public boolean isMatch(Thesis thesis) {
        if (this.state != null && this.state != thesis.getLibraryState()) {
            return false;
        }
        if (this.getYear() != null && !thesis.getEnrolment().getExecutionYear().equals(this.getYear())) {
            return false;
        }
        if (this.text != null && !this.text.isEmpty()) {
            if (thesis.getStudent().getNumber().toString().equals(this.text)) {
                return true;
            }
            if (this.isMatchPerson(thesis.getStudent().getPerson(), this.text)) {
                return true;
            }
            for (String title : thesis.getFinalFullTitle().getAllContents()) {
                if (!title.toLowerCase().contains(this.text.toLowerCase())) continue;
                return true;
            }
            if (thesis.getLibraryReference() != null && thesis.getLibraryReference().contains(this.text)) {
                return true;
            }
            return thesis.getLibraryOperationPerformer() != null && this.isMatchPerson(thesis.getLibraryOperationPerformer(), this.text);
        }
        return true;
    }

    private boolean isMatchPerson(Person person, String text) {
        if (person.getUsername().equals(text)) {
            return true;
        }
        return HumanName.namesMatch(person.getName(), text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ThesisLibraryState getState() {
        return this.state;
    }

    public void setState(ThesisLibraryState state) {
        this.state = state;
    }

    public ExecutionYear getYear() {
        return this.year;
    }

    public void setYear(ExecutionYear year) {
        this.year = year;
    }
}

