/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collection;
import java.util.Locale;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.CreditsDismissalLog;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CreditsDismissal_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class CreditsDismissal
extends CreditsDismissal_Base {
    public CreditsDismissal() {
    }

    public CreditsDismissal(Credits credits, CurriculumGroup curriculumGroup, Collection<CurricularCourse> noEnrolCurricularCourses) {
        this.checkIfCanCreate(credits, noEnrolCurricularCourses, curriculumGroup);
        this.init(credits, curriculumGroup);
        this.checkParameters(credits);
        if (noEnrolCurricularCourses != null) {
            this.getNoEnrolCurricularCoursesSet().addAll(noEnrolCurricularCourses);
        }
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    private void checkIfCanCreate(Credits credits, Collection<CurricularCourse> noEnrolCurricularCourses, CurriculumGroup curriculumGroup) {
        for (Dismissal dismissal : curriculumGroup.getChildDismissals()) {
            CreditsDismissal creditsDismissal;
            if (!dismissal.isCreditsDismissal() || !this.isSimilar(credits, noEnrolCurricularCourses, creditsDismissal = (CreditsDismissal)((Object)dismissal))) continue;
            throw new DomainException("error.CreditsDismissal.already.exists.similar", curriculumGroup.getName().getContent());
        }
    }

    private boolean isSimilar(Credits credits, Collection<CurricularCourse> curricularCourses, CreditsDismissal creditsDismissalToCheck) {
        boolean result = true;
        result &= this.hasSameEctsCredits(credits.getGivenCredits(), creditsDismissalToCheck);
        result &= this.hasSameSourceIEnrolments(credits.getIEnrolments(), (Dismissal)((Object)creditsDismissalToCheck));
        return result &= curricularCourses == null || this.hasSameNoEnrolCurricularCourses(curricularCourses, creditsDismissalToCheck);
    }

    private void checkParameters(Credits credits) {
        if (credits.getGivenCredits() == null) {
            throw new DomainException("error.CreditsDismissal.invalid.credits", new String[0]);
        }
    }

    public boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return (executionSemester == null || this.getExecutionPeriod().isBeforeOrEquals(executionSemester)) && this.hasEquivalentNoEnrolCurricularCourse(curricularCourse);
    }

    private boolean hasEquivalentNoEnrolCurricularCourse(CurricularCourse curricularCourse) {
        for (CurricularCourse course : this.getNoEnrolCurricularCoursesSet()) {
            if (!course.isEquivalent(curricularCourse)) continue;
            return true;
        }
        return false;
    }

    public Double getEctsCredits() {
        return this.getCredits().getGivenCredits();
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return false;
    }

    public MultiLanguageString getName() {
        return new MultiLanguageString(MultiLanguageString.pt, BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)new Locale("pt", "PT"), (String)"label.group.credits", (String[])new String[0]));
    }

    public Dismissal getDismissal(CurricularCourse curricularCourse) {
        return this.getNoEnrolCurricularCoursesSet().contains((Object)curricularCourse) ? this : null;
    }

    public void delete() {
        this.getNoEnrolCurricularCoursesSet().clear();
        super.delete();
    }

    void deleteFromCredits() {
        this.getNoEnrolCurricularCoursesSet().clear();
        super.deleteFromCredits();
    }

    public boolean isCreditsDismissal() {
        return true;
    }

    public boolean isSimilar(Dismissal dismissal) {
        return dismissal.isCreditsDismissal() && this.hasSameSourceIEnrolments(this.getSourceIEnrolments(), dismissal) && this.hasSameNoEnrolCurricularCourses(this.getNoEnrolCurricularCoursesSet(), (CreditsDismissal)((Object)dismissal)) && this.hasSameEctsCredits(this.getEctsCredits(), (CreditsDismissal)((Object)dismissal));
    }

    private boolean hasSameNoEnrolCurricularCourses(Collection<CurricularCourse> curricularCourses, CreditsDismissal dismissal) {
        return curricularCourses.containsAll(dismissal.getNoEnrolCurricularCoursesSet()) && curricularCourses.size() == dismissal.getNoEnrolCurricularCoursesSet().size();
    }

    private boolean hasSameEctsCredits(Double ectsCredits, CreditsDismissal dismissal) {
        return ectsCredits.equals(dismissal.getEctsCredits());
    }

    protected void createCurriculumLineLog(EnrolmentAction action) {
        new CreditsDismissalLog(action, this.getRegistration(), this.getCurriculumGroup(), this.getCredits(), this.getExecutionPeriod(), this.getCurrentUser());
    }

    public Grade getEctsGrade(DateTime processingDate) {
        return EctsTableIndex.convertGradeToEcts(this.getStudentCurricularPlan().getDegree(), (CurriculumLine)((Object)this), this.getGrade(), processingDate);
    }
}

