/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.util.Comparator;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import pt.ist.fenixframework.DomainObject;

public abstract class RegistrationAcademicServiceRequest
extends RegistrationAcademicServiceRequest_Base {
    public static Comparator<RegistrationAcademicServiceRequest> COMPARATOR_BY_SERVICE_REQUEST_NUMBER_AND_ID = new Comparator<RegistrationAcademicServiceRequest>(){

        @Override
        public int compare(RegistrationAcademicServiceRequest o1, RegistrationAcademicServiceRequest o2) {
            if (o1.getServiceRequestNumber().compareTo(o2.getServiceRequestNumber()) != 0) {
                return o1.getServiceRequestNumber().compareTo(o2.getServiceRequestNumber());
            }
            return DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2);
        }
    };

    protected RegistrationAcademicServiceRequest() {
    }

    public void init(RegistrationAcademicServiceRequestCreateBean bean) {
        this.checkParameters(bean);
        super.setRegistration(bean.getRegistration());
        super.init((AcademicServiceRequestCreateBean)bean, this.getDegree().getAdministrativeOffice());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        this.checkRegistration(bean);
        this.checkRegistrationIsNotTransited(bean);
        this.checkRegistrationStartDate(bean);
        this.checkRegistrationExecutionYear(bean);
    }

    protected void checkRegistrationExecutionYear(RegistrationAcademicServiceRequestCreateBean bean) {
        if (bean.getExecutionYear() != null && bean.getExecutionYear().isBefore(bean.getRegistration().getStartExecutionYear())) {
            throw new DomainException("error.RegistrationAcademicServiceRequest.executionYear.before.registrationStartDate", new String[0]);
        }
    }

    protected void checkRegistrationStartDate(RegistrationAcademicServiceRequestCreateBean bean) {
        if (ExecutionYear.readByDateTime(bean.getRequestDate()).isBefore(bean.getRegistration().getStartExecutionYear())) {
            throw new DomainException("error.RegistrationAcademicServiceRequest.requestDate.before.registrationStartDate", new String[0]);
        }
    }

    protected void checkRegistrationIsNotTransited(RegistrationAcademicServiceRequestCreateBean bean) {
        if (!this.isAvailableForTransitedRegistrations() && bean.getRegistration().isTransited()) {
            throw new DomainException("RegistrationAcademicServiceRequest.registration.cannot.be.transited", new String[0]);
        }
    }

    protected void checkRegistration(RegistrationAcademicServiceRequestCreateBean bean) {
        if (bean.getRegistration() == null) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.registration.cannot.be.null", new String[0]);
        }
    }

    public Degree getDegree() {
        return this.getRegistration().getDegree();
    }

    public AcademicProgram getAcademicProgram() {
        return this.getDegree();
    }

    public void setRegistration(Registration registration) {
        throw new DomainException("error.serviceRequests.RegistrationAcademicServiceRequest.cannot.modify.registration", new String[0]);
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        ExecutionYear executionYear = this.getExecutionYear() != null ? this.getExecutionYear() : ExecutionYear.readByDateTime(this.getRequestDate());
        return this.getRegistration().getStudentCurricularPlan(executionYear);
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public boolean isBolonha() {
        return this.getDegree().isBolonhaDegree();
    }

    public boolean isRequestForRegistration() {
        return true;
    }

    protected void disconnect() {
        super.setRegistration(null);
        super.disconnect();
    }

    public Person getPerson() {
        return this.getRegistration().getPerson();
    }

    public Student getStudent() {
        return this.getRegistration().getStudent();
    }

    public abstract boolean isAvailableForTransitedRegistrations();

    public boolean hasRegistration() {
        return this.getRegistration() != null;
    }
}

