/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.EurAceReportFile_Base;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class EurAceReportFile
extends EurAceReportFile_Base {
    public String getJobName() {
        return "Listagem para EUR-ACE";
    }

    protected String getPrefix() {
        return "eurAce";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        this.setDegreeHeaders(spreadsheet);
        spreadsheet.setHeader("Nome disciplina");
        spreadsheet.setHeader("Id do docente");
        spreadsheet.setHeader("C\u00f3digo disciplina execucao");
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!EurAceReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree)) continue;
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                if (!EurAceReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (DegreeCurricularPlan)degreeCurricularPlan)) continue;
                for (CurricularCourse curricularCourse : degreeCurricularPlan.getAllCurricularCourses()) {
                    if (!EurAceReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (CurricularCourse)curricularCourse)) continue;
                    for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        if (!EurAceReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (ExecutionCourse)executionCourse)) continue;
                        for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                            if (!professorship.hasTeacher()) continue;
                            Teacher teacher = professorship.getTeacher();
                            Spreadsheet.Row row = spreadsheet.addRow();
                            this.setDegreeCells(row, degree);
                            row.setCell(curricularCourse.getName());
                            row.setCell(teacher.getPerson().getUsername());
                            row.setCell(GepReportFile.getExecutionCourseCode(executionCourse));
                        }
                    }
                }
            }
        }
    }
}

