/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdGuiderAcceptanceLetter_Base;
import org.fenixedu.bennu.core.domain.User;

public class PhdGuiderAcceptanceLetter
extends PhdGuiderAcceptanceLetter_Base {
    protected PhdGuiderAcceptanceLetter() {
    }

    public PhdGuiderAcceptanceLetter(PhdParticipant guider, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        this();
        this.init(guider, documentType, remarks, content, filename, uploader);
    }

    private void init(PhdParticipant guider, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        PhdIndividualProgramProcess process2 = guider.getIndividualProcess();
        this.checkParameters(guider, documentType);
        super.init((PhdProgramProcess)((Object)process2), documentType, remarks, content, filename, uploader);
        this.setPhdGuider(guider);
    }

    protected void checkParameters(PhdParticipant guider, PhdIndividualProgramDocumentType documentType) {
        this.checkDocumentType(documentType);
        if (guider == null) {
            throw new DomainException("phd.candidacy.PhdGuiderAcceptanceLetter.guider.required", new String[0]);
        }
    }

    private void checkDocumentType(PhdIndividualProgramDocumentType documentType) {
        if (PhdIndividualProgramDocumentType.GUIDER_ACCEPTANCE_LETTER.equals((Object)documentType)) {
            return;
        }
        if (PhdIndividualProgramDocumentType.ASSISTENT_GUIDER_ACCEPTANCE_LETTER.equals((Object)documentType)) {
            return;
        }
        throw new DomainException("phd.candidacy.PhdGuiderAcceptanceLetter.invalid.type", new String[0]);
    }

    public boolean isAccessible(User user) {
        PhdIndividualProgramProcess process2 = (PhdIndividualProgramProcess)((Object)this.getPhdProgramProcess());
        if (!process2.getCandidacyProcess().isPublicCandidacy()) {
            return super.isAccessible(user);
        }
        if (!process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().isOpen()) {
            return super.isAccessible(user);
        }
        return true;
    }
}

