/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;

public class DismissalCurriculumModuleWrapper
extends EnroledCurriculumModuleWrapper {
    private static final long serialVersionUID = 12L;
    private Dismissal dismissal;

    public DismissalCurriculumModuleWrapper(Dismissal dismissal, ExecutionSemester executionSemester) {
        super((CurriculumModule)((Object)dismissal.getCurriculumGroup()), executionSemester);
        this.setDismissal(dismissal);
    }

    private Dismissal getDismissal() {
        return this.dismissal;
    }

    private void setDismissal(Dismissal dismissal) {
        this.dismissal = dismissal;
    }

    private boolean hasDismissal() {
        return this.getDismissal() != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DismissalCurriculumModuleWrapper) {
            DismissalCurriculumModuleWrapper other = (DismissalCurriculumModuleWrapper)obj;
            return this.getDismissal().equals(other.getDismissal());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDismissal().hashCode();
    }

    @Override
    public boolean canCollectRules() {
        return true;
    }

    @Override
    public boolean isAnnualCurricularCourse(ExecutionYear executionYear) {
        if (this.hasDegreeModule() && this.getDegreeModule().isLeaf()) {
            return ((CurricularCourse)((Object)this.getDegreeModule())).isAnual(executionYear);
        }
        return false;
    }

    @Override
    public boolean isDissertation() {
        if (this.hasDismissal()) {
            return this.getDismissal().hasCurricularCourse() ? this.getDismissal().getCurricularCourse().isDissertation() : false;
        }
        return false;
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }
}

