/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.RestrictionNotEnroledDegreeModule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.RestrictionNotEnroledDegreeModuleVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.dto.GenericPair;

public class RestrictionNotEnroledDegreeModule
extends RestrictionNotEnroledDegreeModule_Base {
    public RestrictionNotEnroledDegreeModule() {
    }

    private RestrictionNotEnroledDegreeModule(CurricularCourse toNotBeEnroled) {
        if (toNotBeEnroled == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.setPrecedenceDegreeModule((DegreeModule)((Object)toNotBeEnroled));
        this.setCurricularRuleType(CurricularRuleType.RESTRICTION_NOT_ENROLED_DEGREE_MODULE);
    }

    protected RestrictionNotEnroledDegreeModule(CurricularCourse toApplyRule, CurricularCourse toNotBeEnroled, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO, ExecutionSemester begin, ExecutionSemester end) {
        this(toNotBeEnroled);
        this.init((DegreeModule)((Object)toApplyRule), contextCourseGroup, begin, end);
        if (curricularPeriodInfoDTO != null) {
            this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
            this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
        }
    }

    protected void edit(DegreeModule notEnroledDegreeModule, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO) {
        this.setPrecedenceDegreeModule(notEnroledDegreeModule);
        this.setContextCourseGroup(contextCourseGroup);
        this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
        this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
    }

    public CurricularCourse getDegreeModuleToApplyRule() {
        return (CurricularCourse)((Object)super.getDegreeModuleToApplyRule());
    }

    public CurricularCourse getPrecedenceDegreeModule() {
        return (CurricularCourse)((Object)super.getPrecedenceDegreeModule());
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        if (this.belongsToCompositeRule() && this.getParentCompositeRule().getCompositeRuleType().equals((Object)LogicOperator.NOT)) {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceEnrolled", true));
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceNotEnrolled", true));
        }
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        String precedenceDegreeModule = this.getPrecedenceDegreeModule().isLeaf() ? this.getPrecedenceDegreeModule().getName() : this.getPrecedenceDegreeModule().getOneFullName();
        labelList.add(new GenericPair<String, Boolean>(precedenceDegreeModule, false));
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inContext", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        if (!this.hasNoCurricularPeriodOrder()) {
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.and", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.in", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getAcademicPeriod().getName(), true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getCurricularPeriodOrder(), false));
        }
        return labelList;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new RestrictionNotEnroledDegreeModuleVerifier();
    }
}

