/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import org.fenixedu.academic.domain.candidacy.GenericApplicationLetterOfRecomentation_Base;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class GenericApplicationLetterOfRecomentation
extends GenericApplicationLetterOfRecomentation_Base {
    public GenericApplicationLetterOfRecomentation(GenericApplicationRecomentation recomentation, String displayName, String fileName, byte[] content) {
        this.init(displayName, fileName, content);
        this.setRecomentation(recomentation);
        this.sendEmailForRecommendationUploadNotification();
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    public boolean isAccessible(User user) {
        return false;
    }

    public void delete() {
        this.setRecomentation(null);
        super.delete();
    }

    public void sendEmailForRecommendationUploadNotification() {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.upload.notification.email.subject", (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.recomentation.upload.notification.email.body", (String[])new String[]{this.getRecomentation().getName(), this.getRecomentation().getInstitution()});
        new Message((Sender)((Object)Bennu.getInstance().getSystemSender()), this.getRecomentation().getGenericApplication().getEmail(), subject, body);
    }
}

