/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituation_Base;
import org.fenixedu.academic.domain.candidacy.workflow.CandidacyOperation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.workflow.IState;
import org.fenixedu.academic.domain.util.workflow.IStateWithOperations;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.academic.domain.util.workflow.StateBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class CandidacySituation
extends CandidacySituation_Base
implements IStateWithOperations {
    public static Comparator<CandidacySituation> DATE_COMPARATOR = new Comparator<CandidacySituation>(){

        @Override
        public int compare(CandidacySituation leftCandidacySituation, CandidacySituation rightCandidacySituation) {
            int comparationResult = leftCandidacySituation.getSituationDate().compareTo((ReadableInstant)rightCandidacySituation.getSituationDate());
            if (comparationResult == 0) {
                CandidacySituationType leftType = leftCandidacySituation.getCandidacySituationType();
                CandidacySituationType rightType = rightCandidacySituation.getCandidacySituationType();
                return leftType.compareTo(rightType);
            }
            return comparationResult;
        }
    };

    protected CandidacySituation() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setSituationDate(new DateTime());
    }

    protected final void init(Candidacy candidacy, Person person) {
        this.checkParameters(candidacy, person);
        super.setCandidacy(candidacy);
        super.setPerson(person);
        if (this.canExecuteOperationAutomatically()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new DomainException("error.candidacy.CandidacySituation.cannot.execute.operation", new String[0]);
            }
            this.getOperations().iterator().next().execute(person);
        }
    }

    private Set<Operation> getOperations() {
        return this.getCandidacy().getOperations(this);
    }

    public void executeSingleOperation() {
    }

    private void checkParameters(Candidacy candidacy, Person person) {
        if (candidacy == null) {
            throw new DomainException("error.candidacy.CandidacySituation.candidacy.cannot.be.null", new String[0]);
        }
        if (person == null) {
            throw new DomainException("error.candidacy.CandidacySituation.person.cannot.be.null", new String[0]);
        }
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getCandidacySituationType().getQualifiedName(), (String[])new String[0]);
    }

    public boolean canChangePersonalData() {
        return false;
    }

    public boolean getCanCandidacyDataBeValidated() {
        return false;
    }

    public boolean getCanGeneratePass() {
        return true;
    }

    public boolean getCanRegister() {
        return false;
    }

    @Override
    public Collection<Operation> getOperationsForPerson(Person person) {
        HashSet<Operation> operationsForPerson = new HashSet<Operation>();
        for (Operation operation : this.getOperations()) {
            if (!operation.isAuthorized(person)) continue;
            operationsForPerson.add(operation);
        }
        return operationsForPerson;
    }

    public Operation getOperationByTypeAndPerson(CandidacyOperationType type, Person person) {
        for (Operation operation : this.getOperationsForPerson(person)) {
            if (((CandidacyOperation)operation).getType() != type) continue;
            return operation;
        }
        return null;
    }

    @Override
    public void onOperationFinished(Operation operation, Person person) {
        this.getCandidacy().moveToNextState(((CandidacyOperation)operation).getType(), person);
    }

    @Override
    public IState nextState() {
        return this.getCandidacy().nextState();
    }

    @Override
    public IState nextState(StateBean bean) {
        return this.getCandidacy().nextState(bean.getNextState());
    }

    @Override
    public Set<String> getValidNextStates() {
        return this.getCandidacy().getValidNextStates();
    }

    @Override
    public void checkConditionsToForward() {
        this.getCandidacy().checkConditionsToForward();
    }

    @Override
    public void checkConditionsToForward(StateBean bean) {
        this.getCandidacy().checkConditionsToForward(bean.getNextState());
    }

    public abstract CandidacySituationType getCandidacySituationType();

    public abstract boolean canExecuteOperationAutomatically();

    public void delete() {
        this.setCandidacy(null);
        this.setPerson(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

