/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.serviceAgreementTemplates;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplatePaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlanForStudentsEnroledOnlyInSecondSemester;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class DegreeCurricularPlanServiceAgreementTemplate
extends DegreeCurricularPlanServiceAgreementTemplate_Base {
    private DegreeCurricularPlanServiceAgreementTemplate() {
    }

    public DegreeCurricularPlanServiceAgreementTemplate(DegreeCurricularPlan degreeCurricularPlan) {
        this();
        this.init(degreeCurricularPlan);
    }

    private void checkParameters(DegreeCurricularPlan degreeCurricularPlan) {
        if (degreeCurricularPlan == null) {
            throw new DomainException("error.accounting.agreement.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate.degreeCurricularPlan.cannot.be.null", new String[0]);
        }
    }

    protected void init(DegreeCurricularPlan degreeCurricularPlan) {
        this.checkParameters(degreeCurricularPlan);
        this.checkRulesToCreate(degreeCurricularPlan);
        super.setDegreeCurricularPlan(degreeCurricularPlan);
    }

    private void checkRulesToCreate(DegreeCurricularPlan degreeCurricularPlan) {
        if (DegreeCurricularPlanServiceAgreementTemplate.readByDegreeCurricularPlan(degreeCurricularPlan) != null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate.degree.curricular.plan.already.has.template.defined", new String[0]);
        }
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        throw new DomainException("error.accounting.agreement.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate.cannot.modify.degreeCurricularPlan", new String[0]);
    }

    public GratuityPaymentPlan getGratuityPaymentPlanFor(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        GratuityPaymentPlan result = null;
        for (PaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof GratuityPaymentPlan) || !((GratuityPaymentPlan)((Object)paymentPlan)).isAppliableFor(studentCurricularPlan, executionYear)) continue;
            GratuityPaymentPlan gratuityPaymentPlan = (GratuityPaymentPlan)((Object)paymentPlan);
            if (result == null) {
                result = (GratuityPaymentPlan)((Object)paymentPlan);
                continue;
            }
            if (gratuityPaymentPlan.hasPrecedenceOver(((Object)((Object)result)).getClass())) {
                result = gratuityPaymentPlan;
                continue;
            }
            if (result.hasPrecedenceOver(((Object)((Object)gratuityPaymentPlan)).getClass())) continue;
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate.more.than.one.gratuity.payment.plan.is.appliable", new String[0]);
        }
        return result == null ? this.getDefaultPaymentPlan(executionYear) : result;
    }

    public List<GratuityPaymentPlan> getGratuityPaymentPlans() {
        ArrayList<GratuityPaymentPlan> result = new ArrayList<GratuityPaymentPlan>();
        for (PaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof GratuityPaymentPlan)) continue;
            result.add((GratuityPaymentPlan)((Object)paymentPlan));
        }
        return result;
    }

    public GratuityPaymentPlan getDefaultPaymentPlan(ExecutionYear executionYear) {
        return (GratuityPaymentPlan)((Object)super.getDefaultPaymentPlan(executionYear));
    }

    public boolean hasFullGratuityPaymentPlanFor(ExecutionYear executionYear) {
        for (PaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof FullGratuityPaymentPlan) || paymentPlan.getExecutionYear() != executionYear) continue;
            return true;
        }
        return false;
    }

    public boolean hasGratuityPaymentPlanForStudentsEnroledOnlyInSecondSemesterBy(ExecutionYear executionYear) {
        for (PaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof GratuityPaymentPlanForStudentsEnroledOnlyInSecondSemester) || paymentPlan.getExecutionYear() != executionYear) continue;
            return true;
        }
        return false;
    }

    public static DegreeCurricularPlanServiceAgreementTemplate readByDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        for (ServiceAgreementTemplate serviceAgreementTemplate : Bennu.getInstance().getServiceAgreementTemplatesSet()) {
            DegreeCurricularPlanServiceAgreementTemplate degreeCurricularPlanServiceAgreementTemplate;
            if (!(serviceAgreementTemplate instanceof DegreeCurricularPlanServiceAgreementTemplate) || (degreeCurricularPlanServiceAgreementTemplate = (DegreeCurricularPlanServiceAgreementTemplate)((Object)serviceAgreementTemplate)).getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return degreeCurricularPlanServiceAgreementTemplate;
        }
        return null;
    }

    public List<GratuityPaymentPlan> getGratuityPaymentPlansFor(ExecutionYear executionYear) {
        ArrayList<GratuityPaymentPlan> result = new ArrayList<GratuityPaymentPlan>();
        for (ServiceAgreementTemplatePaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof GratuityPaymentPlan) || !paymentPlan.isFor(executionYear)) continue;
            result.add((GratuityPaymentPlan)((Object)paymentPlan));
        }
        return result;
    }
}

