/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.phd.debts.PhdEvent;
import org.fenixedu.academic.util.MultiLanguageString;

public class PhdEventWrapper
implements Wrapper {
    PhdEvent event;

    public PhdEventWrapper(PhdEvent event) {
        this.event = event;
    }

    @Override
    public String getStudentNumber() {
        if (this.event.getPerson().getStudent() != null) {
            return this.event.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.event.getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        if (this.event.getPhdIndividualProgramProcess().getWhenFormalizedRegistration() != null) {
            return this.event.getPhdIndividualProgramProcess().getWhenFormalizedRegistration().toString("dd/MM/yyyy");
        }
        return "--";
    }

    @Override
    public String getExecutionYear() {
        return this.getForExecutionYear().getName();
    }

    @Override
    public String getDegreeName() {
        return "--";
    }

    @Override
    public String getDegreeType() {
        return "--";
    }

    @Override
    public String getPhdProgramName() {
        return this.event.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent(MultiLanguageString.pt);
    }

    @Override
    public String getEnrolledECTS() {
        return "--";
    }

    @Override
    public String getRegime() {
        return "--";
    }

    @Override
    public String getEnrolmentModel() {
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return "--";
    }

    @Override
    public String getResidenceMonth() {
        return "--";
    }

    @Override
    public String getStudiesType() {
        return "Programa Doutoral";
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return !ExecutionYear.readByDateTime(this.event.getWhenOccured()).isBefore(executionYear);
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return ExecutionYear.readByDateTime(this.event.getWhenOccured());
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return this.event.getPhdIndividualProgramProcess().getAdministrativeOffice();
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

