/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityPR_Base;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.IGratuityPR;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public abstract class DFAGratuityPR
extends DFAGratuityPR_Base
implements IGratuityPR {
    protected DFAGratuityPR() {
    }

    public DFAGratuityPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal partialAcceptedPercentage) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, partialAcceptedPercentage);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal dfaPartialAcceptedPercentage) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(dfaTotalAmount, dfaPartialAcceptedPercentage);
        super.setDfaTotalAmount(dfaTotalAmount);
        super.setDfaPartialAcceptedPercentage(dfaPartialAcceptedPercentage);
    }

    private void checkParameters(Money dfaTotalAmount, BigDecimal dfaPartialAcceptedPercentage) {
        if (dfaTotalAmount == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityPR.dfaTotalAmount.cannot.be.null", new String[0]);
        }
        if (dfaPartialAcceptedPercentage == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityPR.dfaPartialAcceptedPercentage.cannot.be.null", new String[0]);
        }
    }

    public void setDfaTotalAmount(Money dfaTotalAmount) {
        throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityPR.cannot.modify.dfaTotalAmount", new String[0]);
    }

    public void setDfaPartialAcceptedPercentage(BigDecimal dfaPartialAcceptedPercentage) {
        throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityPR.cannot.modify.dfaPartialAcceptedPercentage", new String[0]);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityPR.invalid.number.of.entryDTOs", new String[0]);
        }
        this.checkIfCanAddAmount(entryDTOs.iterator().next().getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, this.getEntryType(), entryDTOs.iterator().next().getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToAdd, Event event, DateTime when) {
        if (((GratuityEvent)((Object)event)).isCustomEnrolmentModel()) {
            this.checkIfCanAddAmountForCustomEnrolmentModel(event, when, amountToAdd);
        } else {
            this.checkIfCanAddAmountForCompleteEnrolmentModel(amountToAdd, event, when);
        }
    }

    private void checkIfCanAddAmountForCustomEnrolmentModel(Event event, DateTime when, Money amountToAdd) {
        if (event.calculateAmountToPay(when).greaterThan(amountToAdd)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.DFAGratuityPR.amount.being.payed.must.be.equal.to.amout.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    private void checkIfCanAddAmountForCompleteEnrolmentModel(Money amountToAdd, Event event, DateTime when) {
        if (this.hasAlreadyPayedAnyAmount(event, when)) {
            Money totalFinalAmount = event.getPayedAmount().add(amountToAdd);
            if (!totalFinalAmount.greaterOrEqualThan(this.calculateTotalAmountToPay(event, when)) && !totalFinalAmount.equals(this.getPartialPaymentAmount(event, when))) {
                throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.DFAGratuityPR.amount.being.payed.must.be.equal.to.amout.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
            }
        } else if (!this.isPayingTotalAmount(event, when, amountToAdd) && !this.isPayingPartialAmount(event, when, amountToAdd)) {
            LabelFormatter percentageLabelFormatter = new LabelFormatter();
            percentageLabelFormatter.appendLabel(this.getDfaPartialAcceptedPercentage().multiply(BigDecimal.valueOf(100L)).toString());
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.DFAGratuityPR.invalid.partial.payment.value", event.getDescriptionForEntryType(this.getEntryType()), percentageLabelFormatter);
        }
    }

    private boolean isPayingTotalAmount(Event event, DateTime when, Money amountToAdd) {
        return amountToAdd.greaterOrEqualThan(event.calculateAmountToPay(when));
    }

    private boolean isPayingPartialAmount(Event event, DateTime when, Money amountToAdd) {
        return amountToAdd.equals(this.getPartialPaymentAmount(event, when));
    }

    private boolean hasAlreadyPayedAnyAmount(Event event, DateTime when) {
        return !this.calculateTotalAmountToPay(event, when).equals(event.calculateAmountToPay(when));
    }

    private Money getPartialPaymentAmount(Event event, DateTime when) {
        return this.calculateTotalAmountToPay(event, when).multiply(this.getDfaPartialAcceptedPercentage());
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money result = ((GratuityEvent)((Object)event)).isCustomEnrolmentModel() ? this.calculateDFAGratuityTotalAmountToPay(event) : this.getDfaTotalAmount();
        return result;
    }

    protected abstract Money calculateDFAGratuityTotalAmountToPay(Event var1);

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        BigDecimal discountPercentage = applyDiscount ? this.getDiscountPercentage(event, amountToPay) : BigDecimal.ZERO;
        return amountToPay.multiply(BigDecimal.ONE.subtract(discountPercentage));
    }

    private BigDecimal getDiscountPercentage(Event event, Money amount) {
        return ((DfaGratuityEvent)((Object)event)).calculateDiscountPercentage(amount);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    @Override
    public Money getDefaultGratuityAmount(ExecutionYear executionYear) {
        return this.getDfaTotalAmount();
    }
}

