/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.candidacy;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.postingRules.candidacy.SecondCycleIndividualCandidacyPR_Base;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacy;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class SecondCycleIndividualCandidacyPR
extends SecondCycleIndividualCandidacyPR_Base {
    protected SecondCycleIndividualCandidacyPR() {
    }

    public SecondCycleIndividualCandidacyPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_FEE, EventType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    public SecondCycleIndividualCandidacyPR edit(Money fixedAmount) {
        this.deactivate();
        return new SecondCycleIndividualCandidacyPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        SecondCycleIndividualCandidacyEvent secondCycleEvent = (SecondCycleIndividualCandidacyEvent)((Object)event);
        return super.doCalculationForAmountToPay(event, when, applyDiscount).multiply(((SecondCycleIndividualCandidacy)((Object)secondCycleEvent.getIndividualCandidacy())).getSelectedDegreesSet().size());
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        SecondCycleIndividualCandidacyEvent candidacyEvent = (SecondCycleIndividualCandidacyEvent)((Object)event);
        if (candidacyEvent.hasSecondCycleIndividualCandidacyExemption()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    public PaymentCodeType calculatePaymentCodeTypeFromEvent(Event event, DateTime when, boolean applyDiscount) {
        return PaymentCodeType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_PROCESS;
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(event, when);
        Money payedAmount = event.getPayedAmount(when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, totalAmountToPay, payedAmount, totalAmountToPay.subtract(payedAmount), event.getDescriptionForEntryType(this.getEntryType()), totalAmountToPay.subtract(payedAmount)));
    }

    protected void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
    }
}

