/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.IPastRequestEvent;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PastExtraExamRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.ExtraExamRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;

public class PastExtraExamRequestEvent
extends PastExtraExamRequestEvent_Base
implements IPastRequestEvent {
    protected PastExtraExamRequestEvent() {
    }

    public PastExtraExamRequestEvent(AdministrativeOffice administrativeOffice, Person person, ExtraExamRequest request) {
        this();
        super.init(administrativeOffice, EventType.PAST_EXTRA_EXAM_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)request));
    }

    @Override
    public void setPastAmount(Money amount) {
        throw new DomainException("error.accounting.events.cannot.modify.pastAmount", new String[0]);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }
}

