/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.PersistentStudentGroup_Base;
import org.fenixedu.academic.domain.accessControl.StudentGroup;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;

public class PersistentStudentGroup
extends PersistentStudentGroup_Base {
    protected PersistentStudentGroup(DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        this.setDegreeType(degreeType);
        this.setDegree(degree);
        this.setCycle(cycle);
        this.setCampus(campus);
        this.setExecutionCourse(executionCourse);
        this.setCurricularYear(curricularYear);
        this.setExecutionYear(executionYear);
        if (degree != null || executionCourse != null || campus != null || curricularYear != null && executionYear != null) {
            this.setRootForFenixPredicate(null);
        }
    }

    public Group toGroup() {
        return StudentGroup.get(this.getDegreeType(), this.getDegree(), this.getCycle(), this.getCampus(), this.getExecutionCourse(), this.getCurricularYear(), this.getExecutionYear());
    }

    protected void gc() {
        this.setCampus(null);
        this.setDegree(null);
        this.setExecutionCourse(null);
        this.setCurricularYear(null);
        this.setExecutionYear(null);
        super.gc();
    }

    public static PersistentStudentGroup getInstance() {
        return PersistentStudentGroup.getInstance(() -> PersistentStudentGroup.filter(PersistentStudentGroup.class), null, null, null, null, null, null, null);
    }

    public static PersistentStudentGroup getInstance(DegreeType degreeType) {
        return PersistentStudentGroup.getInstance(() -> PersistentStudentGroup.filter(PersistentStudentGroup.class), degreeType, null, null, null, null, null, null);
    }

    public static PersistentStudentGroup getInstance(CycleType cycle) {
        return PersistentStudentGroup.getInstance(() -> PersistentStudentGroup.filter(PersistentStudentGroup.class), null, null, cycle, null, null, null, null);
    }

    public static PersistentStudentGroup getInstance(Degree degree, CycleType cycle) {
        return PersistentStudentGroup.getInstance(() -> degree.getStudentGroupSet().stream(), null, degree, cycle, null, null, null, null);
    }

    public static PersistentStudentGroup getInstance(Space campus) {
        return PersistentStudentGroup.getInstance(() -> campus.getStudentGroupSet().stream(), null, null, null, campus, null, null, null);
    }

    public static PersistentStudentGroup getInstance(Degree degree, CurricularYear curricularYear, ExecutionYear executionYear) {
        return PersistentStudentGroup.getInstance(() -> curricularYear.getStudentGroupSet().stream(), null, degree, null, null, null, curricularYear, executionYear);
    }

    public static PersistentStudentGroup getInstance(ExecutionCourse executionCourse) {
        return PersistentStudentGroup.getInstance(() -> executionCourse.getStudentGroupSet().stream(), null, null, null, null, executionCourse, null, null);
    }

    public static PersistentStudentGroup getInstance(DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        if (curricularYear != null) {
            return PersistentStudentGroup.getInstance(() -> curricularYear.getStudentGroupSet().stream(), degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
        }
        if (executionCourse != null) {
            return PersistentStudentGroup.getInstance(() -> executionCourse.getStudentGroupSet().stream(), degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
        }
        if (campus != null) {
            return PersistentStudentGroup.getInstance(() -> campus.getStudentGroupSet().stream(), degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
        }
        if (degree != null) {
            return PersistentStudentGroup.getInstance(() -> degree.getStudentGroupSet().stream(), degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
        }
        return PersistentStudentGroup.getInstance(() -> PersistentStudentGroup.filter(PersistentStudentGroup.class), degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
    }

    private static PersistentStudentGroup getInstance(Supplier<Stream<PersistentStudentGroup>> options, DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        return (PersistentStudentGroup)PersistentStudentGroup.singleton(() -> PersistentStudentGroup.select(options, degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear), () -> new PersistentStudentGroup(degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear));
    }

    private static Optional<PersistentStudentGroup> select(Supplier<Stream<PersistentStudentGroup>> options, DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        return options.get().filter(group -> Objects.equals(group.getDegreeType(), degreeType) && Objects.equals(group.getDegree(), degree) && Objects.equals((Object)group.getCycle(), (Object)cycle) && Objects.equals(group.getCampus(), campus) && Objects.equals((Object)group.getExecutionCourse(), (Object)executionCourse) && Objects.equals(group.getCurricularYear(), curricularYear) && Objects.equals(group.getExecutionYear(), executionYear)).findAny();
    }
}

